# Example Device - Implantable Pacemaker - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Example Device - Implantable Pacemaker**

## Example Device: Example Device - Implantable Pacemaker

Profile: [Medical Device (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-medical-device.html)

### UdiCarriers

| | | |
| :--- | :--- | :--- |
| - | **DeviceIdentifier** | **CarrierHRF** |
| * | 12345678901234 | (01)12345678901234 |

**status**: Active

**manufacturer**: MedDevice Inc.

**expirationDate**: 2028-06-30

**lotNumber**: LOTPM1234

**serialNumber**: SN987654321

**modelNumber**: MDX-5000

**type**: Implant

**patient**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-BundleKralikRTG.md#urn-uuid-dd800c46-f71a-4628-b457-6ccaa27dd6bc)



## Resource Content

```json
{
  "resourceType" : "Device",
  "id" : "711e1d43-d5e4-4cbc-b546-74059db270f6",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device"
    ]
  },
  "udiCarrier" : [
    {
      "deviceIdentifier" : "12345678901234",
      "carrierHRF" : "(01)12345678901234"
    }
  ],
  "status" : "active",
  "manufacturer" : "MedDevice Inc.",
  "expirationDate" : "2028-06-30",
  "lotNumber" : "LOTPM1234",
  "serialNumber" : "SN987654321",
  "modelNumber" : "MDX-5000",
  "type" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "40388003"
      }
    ],
    "text" : "Implant"
  },
  "patient" : {
    "reference" : "urn:uuid:dd800c46-f71a-4628-b457-6ccaa27dd6bc"
  }
}

```
