# CZ Header Model to this guide Map - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Header Model to this guide Map**

## ConceptMap: CZ Header Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ConceptMap/HeaderImagingOrder2FHIR-cz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:HeaderImagingOrder2FHIRcz |

 
CZ Imaging Order Header Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "HeaderImagingOrder2FHIR-cz",
  "url" : "https://hl7.cz/fhir/img-order/ConceptMap/HeaderImagingOrder2FHIR-cz",
  "version" : "0.1.0-ballot",
  "name" : "HeaderImagingOrder2FHIRcz",
  "title" : "CZ Header Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Imaging Order Header Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
      "element" : [
        {
          "code" : "Subject.identification",
          "display" : "A.1.1 Identification of the patient/subject",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.identification.givenName",
          "display" : "A.1.1.1 Given name",
          "target" : [
            {
              "code" : "Patient.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.familyName",
          "display" : "A.1.1.2 Familyname/surname",
          "target" : [
            {
              "code" : "Patient.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.dateOfBirth",
          "display" : "A.1.1.3 Date of birth",
          "target" : [
            {
              "code" : "Patient.birthDate",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.dateOfDeath",
          "display" : "A.1.1.4 Date of death",
          "target" : [
            {
              "code" : "Patient.deceased[x].deceasedDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.identifier",
          "display" : "A.1.1.5 Patient identifier",
          "target" : [
            {
              "code" : "Patient.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.citizenship",
          "display" : "A.1.1.6 Citizenship",
          "target" : [
            {
              "code" : "Patient.patient-citizenship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.gender",
          "display" : "A.1.1.7 Gender",
          "target" : [
            {
              "code" : "Patient.gender",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.genderForClinicalUse",
          "display" : "A.1.1.8 Gender",
          "target" : [
            {
              "code" : "Patient.extension:sex-for-clinical-use",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.languageOfCommunication",
          "display" : "A.1.1.9 Language of communication",
          "target" : [
            {
              "code" : "Patient.communication.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.identification.handicap",
          "display" : "A.1.1.10 Handicap",
          "target" : [
            {
              "code" : "Patient.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo",
          "display" : "A.1.2 Patient/subject related contact information",
          "target" : [
            {
              "code" : "Patient",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.address",
          "display" : "A.1.2.1 Address",
          "target" : [
            {
              "code" : "Patient.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.telecom",
          "display" : "A.1.2.2 Telecom",
          "target" : [
            {
              "code" : "Patient.telecom",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "Patient.generalPractitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent",
          "display" : "A.1.2.4 Legal representatives and other contact persons",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.type",
          "display" : "A.1.2.4.1 Contact type",
          "target" : [
            {
              "code" : "Patient.contact.relationship",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.relationToSubject",
          "display" : "A.1.2.4.2 Relationship to the patient",
          "target" : [
            {
              "code" : "Patient.contact.relationship",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.identifier",
          "display" : "A.1.2.4.3 Person identifier",
          "target" : [
            {
              "code" : "Patient.contact",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.givenName",
          "display" : "A.1.2.4.4 Given name",
          "target" : [
            {
              "code" : "Patient.contact.name.given",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.familyName",
          "display" : "A.1.2.4.5 Family name/surname",
          "target" : [
            {
              "code" : "Patient.contact.name.family",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.address",
          "display" : "A.1.2.4.6 Contact person address",
          "target" : [
            {
              "code" : "Patient.contact.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.legalRepresent.telecom",
          "display" : "A.1.2.4.7 Telecom",
          "target" : [
            {
              "code" : "Patient.contact.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
      "element" : [
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "Practitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Identifier",
          "display" : "A.1.2.3.1 Identification of the prefered physician",
          "target" : [
            {
              "code" : "Practitioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Name",
          "display" : "A.1.2.3.2 Name of the prefered physician",
          "target" : [
            {
              "code" : "Practitioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.telecom",
          "display" : "A.1.2.3.6 Telecom",
          "target" : [
            {
              "code" : "Practitioner.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/SubjectCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
      "element" : [
        {
          "code" : "Subject.contactInfo.preferedPhysician",
          "display" : "A.1.2.3 Prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Identifier",
          "display" : "A.1.2.3.1 Identification of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Name",
          "display" : "A.1.2.3.2 Name of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.practiotioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.Specialization",
          "display" : "A.1.2.3.3 Specialization of the prefered physician",
          "target" : [
            {
              "code" : "PractitionerRole.speciality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.providerIdentifierName",
          "display" : "A.1.2.3.4 Identification and name of the provider the doctor represents",
          "target" : [
            {
              "code" : "PractitionerRole.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.providerAddress",
          "display" : "A.1.2.3.5 Provider address",
          "target" : [
            {
              "code" : "PractitionerRole.organization.address",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Subject.contactInfo.preferedPhysician.telecom",
          "display" : "A.1.2.3.6 Telecom",
          "target" : [
            {
              "code" : "PractitionerRole.telecom",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/PayerCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
      "element" : [
        {
          "code" : "Header.payer",
          "display" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
          "target" : [
            {
              "code" : "Composition.section:order.insurance",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:order.entry.ofType(CZ_ImagingInformationAboutOrder).insurance.ofType(CZ_Coverage)"
            }
          ]
        },
        {
          "code" : "Header.payer.insuranceCode",
          "display" : "A.1.3.1 - Health insurance code",
          "target" : [
            {
              "code" : "CZ_Coverage.payor.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.payer.insuranceName",
          "display" : "A.1.3.2 - Health insurance name",
          "target" : [
            {
              "code" : "CZ_Coverage.payor.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.payer.insuranceNumber",
          "display" : "A.1.3.3 - Health insurance number",
          "target" : [
            {
              "code" : "CZ_Coverage.identifier",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageOrderCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
      "element" : [
        {
          "code" : "Header.coverage",
          "display" : "A.1.4 - Information about coverage",
          "target" : [
            {
              "code" : "Composition.section:Coverage",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:Coverage.entry.ofType(CZ_Coverage)"
            }
          ]
        },
        {
          "code" : "Header.coverage.method",
          "display" : "A.1.4.1 - Coverage method",
          "target" : [
            {
              "code" : "CZ_Coverage.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.coverage.informationPayor",
          "display" : "A.1.4.2 - Information about Payor",
          "target" : [
            {
              "code" : "CZ_Coverage.payor",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core",
      "element" : [
        {
          "code" : "Header.author",
          "display" : "A.1.5 - Author (by whom the Imaging Order was/were authored)",
          "target" : [
            {
              "code" : "Composition.author",
              "equivalence" : "equivalent",
              "comment" : "Composition.author.resolve().ofType(CZ_PractitionerRoleCore)"
            }
          ]
        },
        {
          "code" : "Header.author.identifier",
          "display" : "A.1.5.1 - Author identifier",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author.name",
          "display" : "A.1.5.2 - Author name",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author.address",
          "display" : "A.1.5.3 - Author address",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.address",
              "equivalence" : "equivalent",
              "comment" : "ID Organization"
            }
          ]
        },
        {
          "code" : "Header.author.organization",
          "display" : "A.1.5.4 - Author organisation",
          "target" : [
            {
              "code" : "Z_PractitionerRoleCore.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-encounter",
      "element" : [
        {
          "code" : "AuthorCz.organization",
          "display" : "A.1.5.4 - Author organisation",
          "target" : [
            {
              "code" : "CZ_Encounter.serviceProvider",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/RequestedPerformerCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core",
      "element" : [
        {
          "code" : "Header.requestedPerformer",
          "display" : "A.1.6 - Requested Performer",
          "target" : [
            {
              "code" : "CZ_ImagingInformationAboutOrder.performer",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.requestedPerformer.identifier",
          "display" : "A.1.6.1 - Requested Performer identifier",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.requestedPerformer.name",
          "display" : "A.1.6.2 - Requested Performer name",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.requestedPerformer.organizationID",
          "display" : "A.1.6.3 - Requested Performer organisation ID",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.requestedPerformer.organization",
          "display" : "A.1.6.4 - Requested Performer organisation",
          "target" : [
            {
              "code" : "CZ_PractitionerCore.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/AdditionalRecipientCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerRole-core",
      "element" : [
        {
          "code" : "Header.additionalRecipient",
          "display" : "A.1.7 - Additional Recipient",
          "target" : [
            {
              "code" : "Composition.extension:informationRecipient",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.additionalRecipient.identifier",
          "display" : "A.1.7.1 - Additional Recipient identifier",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practitioner.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.additionalRecipient.name",
          "display" : "A.1.7.2 - Additional Recipient name",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.practictioner.name",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.additionalRecipient.organizationID",
          "display" : "A.1.7.3 - Additional Recipient organisation ID",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.organization.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.additionalRecipient.organization",
          "display" : "A.1.7.4 - Additional Recipient organisation",
          "target" : [
            {
              "code" : "CZ_PractitionerRoleCore.organization.name",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/DocumentMetadataCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder",
      "element" : [
        {
          "code" : "Header.documentMetadata.identifier",
          "display" : "A.1.8.1 - Document ID",
          "target" : [
            {
              "code" : "Bundle.identifier",
              "equivalence" : "equivalent",
              "comment" : "If it is the identifier of a particular order instance"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Order date and time",
          "target" : [
            {
              "code" : "Bundle.timeStamp",
              "equivalence" : "equivalent",
              "comment" : "If it is when this particular version of  this order has been assembled into a Bundle."
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/HeaderImagingOrder",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder",
      "element" : [
        {
          "code" : "Header.subject",
          "display" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
          "target" : [
            {
              "code" : "Composition.subject",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author.dateTime",
          "display" : "A.1.5.5 - Date Time",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata",
          "display" : "A.1.8 - Document metadata",
          "target" : [
            {
              "code" : "Composition",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.category",
          "display" : "A.1.8.2 - Document category",
          "target" : [
            {
              "code" : "Composition.category",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.status",
          "display" : "A.1.8.3 - Document status",
          "target" : [
            {
              "code" : "Composition.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.dateTime",
          "display" : "A.1.8.4 - Order date and time",
          "target" : [
            {
              "code" : "Composition.date",
              "equivalence" : "equivalent",
              "comment" : "If it is when this document has been created (indipendently by its version)"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.title",
          "display" : "A.1.8.5 - Document title",
          "target" : [
            {
              "code" : "Composition.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.custodian",
          "display" : "A.1.8.6 - Order custodian",
          "target" : [
            {
              "code" : "Composition.custodian",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.confidentiality",
          "display" : "A.1.8.7 - Confidentiality",
          "target" : [
            {
              "code" : "Composition.confidentiality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.language",
          "display" : "A.1.8.8 - Language",
          "target" : [
            {
              "code" : "Composition.language",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Header.documentMetadata.version",
          "display" : "A.1.8.9 - Version",
          "target" : [
            {
              "code" : "Composition.extension:versionNumber.valueString",
              "equivalence" : "equivalent",
              "comment" : "As business version, not as resource version"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/digitalSignatureCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bundleImageOrder",
      "element" : [
        {
          "code" : "Header.digitalSignatureCz.digitalSignature",
          "display" : "A.1.9.1 - Electronic signature or document seal",
          "target" : [
            {
              "code" : "Bundle.signature.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.digitalSignatureCz.timestamp",
          "display" : "A.1.9.2 - Electronic time stamp",
          "target" : [
            {
              "code" : "Bundle.signature.when",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
