# CZ Attachment Model to this guide Map - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Attachment Model to this guide Map**

## ConceptMap: CZ Attachment Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ConceptMap/AttachmentImagingOrder2FHIR-cz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:AttachmentImagingOrder2FHIRcz |

 
CZ Imaging Order Attachment Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "AttachmentImagingOrder2FHIR-cz",
  "url" : "https://hl7.cz/fhir/img-order/ConceptMap/AttachmentImagingOrder2FHIR-cz",
  "version" : "0.1.0-ballot",
  "name" : "AttachmentImagingOrder2FHIRcz",
  "title" : "CZ Attachment Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Imaging Order Attachment Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/PresentedFormCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder",
      "element" : [
        {
          "code" : "PresentedForm",
          "display" : "A.4 - Presented Form",
          "target" : [
            {
              "code" : "Composition.extension:presentedForm.document",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.contentType",
          "display" : "A.4.1 - Content type of presented form",
          "target" : [
            {
              "code" : "document.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.language",
          "display" : "A.4.2 - Language of presented form",
          "target" : [
            {
              "code" : "document.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.data",
          "display" : "A.4.3 - Data of presented form",
          "target" : [
            {
              "code" : "document.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.url",
          "display" : "A.4.4 - URL of presented form",
          "target" : [
            {
              "code" : "document.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.title",
          "display" : "A.4.5 - Title of presented form",
          "target" : [
            {
              "code" : "document.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PresentedForm.creation",
          "display" : "A.4.6 - Date and time of creation",
          "target" : [
            {
              "code" : "document.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/AttachmentsCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-attachment",
      "element" : [
        {
          "code" : "AttachmentsCz",
          "display" : "A.5 - Additional attachments",
          "target" : [
            {
              "code" : "CZ_Attachment.content",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.contentType",
          "display" : "A.5.1 - Content type of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.contentType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.language",
          "display" : "A.5.2 - Language of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.language",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.data",
          "display" : "A.5.3 - Data of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.url",
          "display" : "A.5.4 - URL of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.url",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.title",
          "display" : "A.5.5 - Title of additional attachments",
          "target" : [
            {
              "code" : "content.attachment.title",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AttachmentsCz.creation",
          "display" : "A.5.6 - Date and time of creation",
          "target" : [
            {
              "code" : "content.attachment.creation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
