# Logical models - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* **Logical models**

## Logical models

This page lists HL7 FHIR logical models used to represent the imaging order.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnImagingOrderCz](StructureDefinition-ImagingOrderCz.md) | A - Imaging Order | Imaging Order |
| [LogEnHeaderImagingOrderCz](StructureDefinition-HeaderImagingOrder.md) | A.1 - Imaging Order header data element | Imaging Order - Imaging Order header data element - A.1 |
| [LogEnSubjectImagingOrderCz](StructureDefinition-SubjectCz.md) | A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject | Imaging Order - Imaging Order subject data element - A.1.1 and A.1.2 |
| [LogEnPayerOrderCz](StructureDefinition-PayerCz.md) | A.1.3 - Health insurance and payment information | Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. |
| [LogEnCoverageOrderCz](StructureDefinition-CoverageOrderCz.md) | A.1.4 - Information about coverage | Coverage information - Information about method of coverage, payer identification data and additional information |
| [LogEnAuthorOrderCz](StructureDefinition-AuthorCz.md) | A.1.5 - Author | Author (by whom the Imaging order was/were authored). Multiple authors could be provided. |
| [LogEnRequestedPerformerOrderCz](StructureDefinition-RequestedPerformerCz.md) | A.1.6 - Requested Performer (processing person) | Person who is requested to process document. |
| [LogEnAdditionalRecipient](StructureDefinition-AdditionalRecipientCz.md) | A.1.7 - Additional Recipient | Additional Recipient (Additional recipients of the finding in addition to the author) |
| [LogEnDocumentMetadataOrderCz](StructureDefinition-DocumentMetadataCz.md) | A.1.8 - Document metadata | Document metadata |
| [LogEnDigitalSignatureCz](StructureDefinition-digitalSignatureCz.md) | A.1.9 - Digital signature | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [LogEnBodyImageOrderCz](StructureDefinition-BodyImageOrderCz.md) | A.2 and A.3 - Body Imaging Order | Body Imaging Order |
| [LogEnImageOrderInformationCz](StructureDefinition-ImageOrderInformationCz.md) | A.2.1 - Order information and A.2.2 - Order reason | Information about order and order reason |
| [LogEnClinicalEventCz](StructureDefinition-ClinicalEventCz.md) | A.2.3 - Clinical event (Encounter) | Clinical event (Encounter) - Information about the clinical event to which the order relates |
| [LogEnCoverageBodyCz](StructureDefinition-CoverageBodyCz.md) | A.2.4 - Information about additional coverage | Additional coverage information - Information about method of coverage, payer identification data and additional information |
| [LogEnImageAppointmentCz](StructureDefinition-ImageAppointmentCz.md) | A.2.5 - Appointment | Appointment - Links to planned care order related to this request form |
| [LogEnSpecimenInformationCz](StructureDefinition-SpecimenInformationCz.md) | A.2.6 - Specimen Information | Information about specimen |
| [LogEnImageSupportingInformationCz](StructureDefinition-ImageSupportingInformationCz.md) | A.3.1 - Supporting Information | Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results |
| [LogEnOrderDataElementsCz](StructureDefinition-OrderDataElementsCz.md) | A.3.2 - Order Data Elements | Order Data Elements - Order/examination data elements |
| [LogEnPlannedCareOrdersCz](StructureDefinition-PlannedCareOrdersCz.md) | A.3.3 - Planned Care Orders | Planned Care Orders - Links to planned care orders related to this request form |
| [LogEnOtherSupportingInformationCz](StructureDefinition-OtherSupportingInformationCz.md) | A.3.4 - Other Supporting Information | Other Supporting Information - Links to other supporting information related to this request form |
| [LogEnPresentedFormCz](StructureDefinition-PresentedFormCz.md) | A.4 - Presented form | Presented form - Entire order as issued. Various formats could be provided, pdf format is recommended. |
| [LogEnAttachmentsCz](StructureDefinition-AttachmentsCz.md) | A.5 - Attachments | Additional attachments. |

