# hl7.fhir.cz.img-order#0.1.0-ballot: HL7 Czech Imaging Order IG

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [Scope and content](scope-and-content.md)
* [Poznámky k implementaci](implementation-notes-cs.md)
* [Logical models](logical-models.md)
* [Mapování logického modelu vizuální podoby dokumentu a příloh](Attachment-map-cs.md)
* [Background](background-cs.md)
* [Oblasti a obsah](scope-and-content-cs.md)
* [Body Model map](Body-map.md)
* [Obligations](obligations-cs.md)
* [Mapování logického modelu těla](Body-map-cs.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Implementation notes](implementation-notes.md)
* [Dependencies](dependencies.md)
* [Copyright](copyright.md)
* [Background](background.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [Presented Form and Attachment Model map](Attachment-map.md)
* [Authors](authors.md)
* [Terminologické aspekty](terminology-considerations-cs.md)
* [Download](downloads-cs.md)
* [Terminology considerations](terminology-considerations.md)
* [Mapování logického modelu hlavičky](Header-map-cs.md)
* [Model maps](model-map.md)
* [Mapování logického modelu](model-map-cs.md)
* [Workflow](workflow-cs.md)
* [Autoři](authors-cs.md)
* [Artifacts](artifacts.md)
* [Download](downloads.md)
* [Header Model map](Header-map.md)
* [Workflow](workflow.md)
* [Příklady užití](use-cases-cs.md)
* [Obligations](obligations.md)
* [Use cases](use-cases.md)

## Resources

### ValueSets

* [CZ Composition Type](ValueSet-cz-composition-type-vs.md)
* [CZ Diagnosis Condition](ValueSet-cz-diagnosis-condition-vs.md)
* [CZ Imaging Procedure](ValueSet-cz-imaging-procedure-vs.md)
* [CZ Mobility Type](ValueSet-cz-mobility-type.md)
* [CZ Mobility Value](ValueSet-cz-mobility-value.md)
* [CZ Modality](ValueSet-cz-modality-vs.md)
* [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-vs.md)
* [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-vs.md)
* [CZ Provision Code](ValueSet-cz-provision-code.md)

### Logicals

* [A.1.7 - Additional Recipient](StructureDefinition-AdditionalRecipientCz.md)
* [A.5 - Attachments](StructureDefinition-AttachmentsCz.md)
* [A.1.5 - Author](StructureDefinition-AuthorCz.md)
* [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)
* [A.2.3 - Clinical event (Encounter)](StructureDefinition-ClinicalEventCz.md)
* [A.2.4 - Information about additional coverage](StructureDefinition-CoverageBodyCz.md)
* [A.1.4 - Information about coverage](StructureDefinition-CoverageOrderCz.md)
* [A.1.8 - Document metadata](StructureDefinition-DocumentMetadataCz.md)
* [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)
* [A.2.5 - Appointment](StructureDefinition-ImageAppointmentCz.md)
* [A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-ImageOrderInformationCz.md)
* [A.3.1 - Supporting Information](StructureDefinition-ImageSupportingInformationCz.md)
* [A - Imaging Order](StructureDefinition-ImagingOrderCz.md)
* [A.3.2 - Order Data Elements](StructureDefinition-OrderDataElementsCz.md)
* [A.3.4 - Other Supporting Information](StructureDefinition-OtherSupportingInformationCz.md)
* [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md)
* [A.3.3 - Planned Care Orders](StructureDefinition-PlannedCareOrdersCz.md)
* [A.4 - Presented form](StructureDefinition-PresentedFormCz.md)
* [A.1.6 - Requested Performer (processing person)](StructureDefinition-RequestedPerformerCz.md)
* [A.2.6 - Specimen Information](StructureDefinition-SpecimenInformationCz.md)
* [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md)
* [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md)
* [A.1.7 - Příjemce nálezu](StructureDefinition-logAdditionalRecipientCz.md)
* [A.5 - Přílohy](StructureDefinition-logAttachmentsCz.md)
* [A.1.5 - Objednatel](StructureDefinition-logAuthorCz.md)
* [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)
* [A.2.3 - Klinická událost (encounter)](StructureDefinition-logClinicalEventCz.md)
* [A.2.4 - Úhrada](StructureDefinition-logCoverageBodyCz.md)
* [A.1.4 - Úhrada](StructureDefinition-logCoverageOrderCz.md)
* [A.1.8 - Metadata dokumentu](StructureDefinition-logDocumentMetadataCz.md)
* [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)
* [A.2.5 - Termín návštěvy](StructureDefinition-logImageAppointmentCz.md)
* [A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)](StructureDefinition-logImageOrderInformationCz.md)
* [A.3.1 - Klinické informace](StructureDefinition-logImageSupportingInformationCz.md)
* [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md)
* [A.3.2 - Datové elementy objednávky / vyšetření](StructureDefinition-logOrderDataElementsCz.md)
* [A.3.4 - Další podpůrné informace](StructureDefinition-logOtherSupportingInformationCz.md)
* [A.1.3 - Zdravotní pojištění](StructureDefinition-logPayerCz.md)
* [A.3.3 - Objednávky plánované péče](StructureDefinition-logPlannedCareOrdersCz.md)
* [A.4 - Vizuální podoba dokumentu](StructureDefinition-logPresentedFormCz.md)
* [A.1.6 - Zpracovatel](StructureDefinition-logRequestedPerformerCz.md)
* [A.2.6 - Informace o vzorku](StructureDefinition-logSpecimenInformationCz.md)
* [A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-logSubjectCz.md)
* [A.1.9 - Elektronické podpisy](StructureDefinition-logdigitalSignatureCz.md)

### Resource Profiles

* [Appointment: Imaging Order (CZ)](StructureDefinition-cz-appointment.md)
* [Body Height: Imaging Order (CZ)](StructureDefinition-cz-bodyheight.md)
* [Body Weight: Imaging Order (CZ)](StructureDefinition-cz-bodyweight.md)
* [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* [Care plan: Imaging Order (CZ)](StructureDefinition-cz-carePlanImage.md)
* [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md)
* [Condition: Clinical question (CZ)](StructureDefinition-cz-conditionClinicalQuestion.md)
* [Condition: Imaging Order (CZ)](StructureDefinition-cz-conditionImage.md)
* [Device Use Statement: Imaging Order (CZ)](StructureDefinition-cz-deviceUseStatement.md)
* [Flag: Imaging Order (CZ)](StructureDefinition-cz-flag.md)
* [Service Request: Imaging Order (CZ)](StructureDefinition-cz-imagingOrderInformation.md)
* [Observation: Imaging Order (CZ)](StructureDefinition-cz-observationImage.md)
* [Patient mobility: Imaging Order (CZ)](StructureDefinition-cz-potientMobility.md)

### ConceptMaps

* [CZ Attachment Model to this guide Map](ConceptMap-AttachmentImagingOrder2FHIR-cz.md)
* [CZ Body Model to this guide Map](ConceptMap-BodyImagingOrder2FHIR-cz.md)
* [CZ Header Model to this guide Map](ConceptMap-HeaderImagingOrder2FHIR-cz.md)

### ImplementationGuides

* [HL7 Czech Imaging Order IG](index.md)

### Parameters

* [expansion](Parameters-expansion.md)

### Examples

* [AppointmentExample (Appointment)](Appointment-AppointmentExample.md)
* [BundleKralikRTG (Bundle)](Bundle-BundleKralikRTG.md)
* [CarePlanExample (CarePlan)](CarePlan-CarePlanExample.md)
* [Imaging Order - Rentgen Ing. Králíka (Composition)](Composition-dbd426a9-d660-4f97-8656-1e39db4a57c9.md)
* [8ca719d9-da84-4bc0-a7da-860eac1347ce (Condition)](Condition-8ca719d9-da84-4bc0-a7da-860eac1347ce.md)
* [92fcdc96-95c0-4cc9-9857-afee3bed913c (Coverage)](Coverage-92fcdc96-95c0-4cc9-9857-afee3bed913c.md)
* [711e1d43-d5e4-4cbc-b546-74059db270f6 (Device)](Device-711e1d43-d5e4-4cbc-b546-74059db270f6.md)
* [MRDevice (Device)](Device-MRDevice.md)
* [e33c93c6-3dd0-4595-9f15-63b9302861d1 (Device)](Device-e33c93c6-3dd0-4595-9f15-63b9302861d1.md)
* [b29cacfd-b05b-44cf-be5a-8b6d76bdc375 (DeviceUseStatement)](DeviceUseStatement-b29cacfd-b05b-44cf-be5a-8b6d76bdc375.md)
* [0af43461-495e-4dfc-82ca-7f3140a60fe7 (DocumentReference)](DocumentReference-0af43461-495e-4dfc-82ca-7f3140a60fe7.md)
* [db16a37b-d393-4767-bb2e-739f9bff16f9 (Encounter)](Encounter-db16a37b-d393-4767-bb2e-739f9bff16f9.md)
* [Ordinace - Jankovcova 2 (Location)](Location-LocationExample.md)
* [4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b (Observation)](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md)
* [ExampleBodyHeight (Observation)](Observation-ExampleBodyHeight.md)
* [ExampleBodyWeight (Observation)](Observation-ExampleBodyWeight.md)
* [d70a725d-baa9-4553-a670-2609b0c0219f (Observation)](Observation-d70a725d-baa9-4553-a670-2609b0c0219f.md)
* [e0861d9f-4b04-465f-b15b-cb01e3a8b677 (Observation)](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md)
* [Všeobecná zdravotní pojišťovna ČR (Organization)](Organization-35e78cc9-6fe2-42a8-8553-83a3f86ce308.md)
* [Fakultní nemocnice Obláčkov (Organization)](Organization-5bdedd9b-27c5-4593-ae3a-968c5f25d253.md)
* [Mracena (Patient)](Patient-Mracena.md)
* [dd800c46-f71a-4628-b457-6ccaa27dd6bc (Patient)](Patient-dd800c46-f71a-4628-b457-6ccaa27dd6bc.md)
* [16793b99-aecc-482d-8283-0e4885e0ca25 (Practitioner)](Practitioner-16793b99-aecc-482d-8283-0e4885e0ca25.md)
* [984dcf34-1924-45a8-8ec5-3d100b67d9be (Practitioner)](Practitioner-984dcf34-1924-45a8-8ec5-3d100b67d9be.md)
* [practitionerExample (Practitioner)](Practitioner-practitionerExample.md)
* [f0ac1e16-61f5-4591-a7eb-1dc586e25349 (PractitionerRole)](PractitionerRole-f0ac1e16-61f5-4591-a7eb-1dc586e25349.md)
* [158808ba-fcca-480e-8188-dec77920ec3c (ServiceRequest)](ServiceRequest-158808ba-fcca-480e-8188-dec77920ec3c.md)
* [210db397-977a-47a0-8a2e-febde6f9f92a (ServiceRequest)](ServiceRequest-210db397-977a-47a0-8a2e-febde6f9f92a.md)
* [5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9 (ServiceRequest)](ServiceRequest-5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9.md)
* [c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed (ServiceRequest)](ServiceRequest-c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed.md)
* [cz-imagingorder-example (ServiceRequest)](ServiceRequest-cz-imagingorder-example.md)
* [d6784779-d008-447d-90cf-89d5d53a0f04 (ServiceRequest)](ServiceRequest-d6784779-d008-447d-90cf-89d5d53a0f04.md)
* [ded5bee9-8a58-4676-919f-0b8e08eaede4 (ServiceRequest)](ServiceRequest-ded5bee9-8a58-4676-919f-0b8e08eaede4.md)
* [fea1dbb8-9e16-4e11-beae-c12829c97381 (ServiceRequest)](ServiceRequest-fea1dbb8-9e16-4e11-beae-c12829c97381.md)
