# Poznámky k implementaci - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* **Poznámky k implementaci**

## Poznámky k implementaci

Na následující stránce naleznete poznámky k implementaci obrazové žádanky. Týkají se tvorby kompozice a naplnění tohoto profilu příslušnými daty.

### Přehled

```
classDiagram
  direction LR
  class CZ_BundleImageOrder{
    <<Bundle>>
  }
  CZ_BundleImageOrder *-- "1" CZ_CompositionImageOrder
  CZ_BundleImageOrder *-- "1" CZ_PatientCore
  CZ_BundleImageOrder *-- "0..*" CZ_ImagingOrderInformation
  CZ_BundleImageOrder *-- "0..*" CZ_ConditionImage
  CZ_BundleImageOrder *-- "0..*" CZ_Coverage
  CZ_BundleImageOrder *-- "0..*" CZ_Encounter
  CZ_BundleImageOrder *-- "0..1" CZ_Appointment
  CZ_BundleImageOrder *-- "0..*" CZ_CarePlanImage
  CZ_BundleImageOrder *-- "0..*" CZ_PractionerCore
  CZ_BundleImageOrder *-- "0..*" CZ_OrganizationCore
  CZ_BundleImageOrder *-- "0..*" CZ_DeviceUseStatement
  CZ_BundleImageOrder *-- "0..*" CZ_Attachment

  CZ_ImagingOrderInformation --> CZ_CompositionImageOrder: composition
  
  CZ_CompositionImageOrder --> CZ_ImagingOrderInformation: section[orderInformation]
  CZ_CompositionImageOrder --> CZ_ConditionImage: section[clinicalQuestion]
  CZ_CompositionImageOrder --> CZ_PractionerCore: author[author]
  CZ_CompositionImageOrder --> CZ_Encounter: encounter
  CZ_CompositionImageOrder --> CZ_OrganizationCore: custodian
  CZ_CompositionImageOrder --> CZ_PatientCore: subject
  CZ_CompositionImageOrder --> CZ_Coverage: section[coverage]
  CZ_CompositionImageOrder --> CZ_Appointment: section[appointment]
  CZ_CompositionImageOrder --> CZ_CarePlanImage: section[carePlan]
  CZ_CompositionImageOrder --> CZ_DeviceUseStatement: section[medicalDevices]
  CZ_CompositionImageOrder --> CZ_Attachment: section[attachments]


```

Obrazová žádanka je reprezentována jako FHIR bundle, který obsahuje zdroje CZ_CompositionImageOrder a všechny zdroje ve stromové struktuře zdrojů, na které se odkazovalo (viz [$document operation](https://www.hl7.org/fhir/composition-operation-document.html)).

### Popis obsahu CZ_CompositionImageOrder

### Sekce a obsah

Dokument je rozdělen do sady povinných a nepovinných sekcí. V případě, že nejsou pro povinnou sekci k dispozici žádná data, lze odůvodnění vyjádřit v `composition.section.emptyReason`.

### Struktura dokumentu

Zobrazovací zpráva obsahuje následující sekce v tomto pořadí:

#### Hlavička obrazové žádanky

Obecné informace o zprávě. Většina informačních prvků v této části zprávy se překrývá s jinými klinickými zprávami. Záhlaví dokumentu obsahuje informace o pacientovi, zdrojové organizaci, autorovi, ověřovateli a správci zprávy.

**Klinická událost (encounter)**

Tento profil umožňuje propojení žádanky s jednou konkrétní klinickou událostí, tj. například návštěvu ambulance, při které žádanka vznikla.

#### Tělo obrazové žádanky

**Informace o objednávce**

Tato požadovaná sekce zahrnuje povinný identifikátor žádanky ([A.2.1.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.identifier)), datum a čas jejího vytvoření ([A.2.1.2](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.dateTime)) – pokud je založena sekce informací, musí tyto informace obsahovat. Mezi volitelné položky patří urgentnost objednávky (z pohledu indikujícího lékaře) vyjádřená mezinárodním kódem ze sytému HL7 ([Request Priority](https://hl7.org/fhir/valueset-request-priority.html)) ([A.2.1.4](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.urgency)), který může nabývat hodnot routine (běžná priorita), urgent (spěchá), asap (co možná nejdříve) a stat (status iminens, STATIM). Další volitelnou položkou je datum a čas požadovaného vyšetření ([A.2.1.3](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.requestedExecdateTime)), zde se nejedná o termín skutečného objednání, otevírá se zde možnost např. zaslat žádanku s prosbou o objednání na den, kdy má pacient ambulantní klinickou kontrolu.

Další požadavky / podrobné specifikace zkoušky ([A.2.1.5](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.orderText)) je další volitelné pole, které může obsahovat další informace pro objednávku. To může zahrnovat například požadavek odesílajícího lékaře na použití specifického dohodnutého protokolu nebo provedení vyšetření na konkrétním přístroji MRI.

Poslední volitelnou položkou jsou informace pro pacienta, jako jsou požadavky na lačno, vysazení léků, rady ohledně klaustrofobie atd.

**Odůvodnění vyšetření (klinická otázka)**

Tato požadovaná sekce zahrnuje indikační diagnózu ([A.2.2.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderReason.problem)), která je vyžadována zdravotními pojišťovnami k proplacení služby. Další položky zahrnují klinickou otázku (věta tázací, měla by končit otazníkem a mělo by možné na ni na základě obrazového vyšetření odpovědět) případně zadanou i kódem SNOMED-CT a důvod objednávky (v podstatě odpovídá stručné epikríze, opět s možností zadat tutéž informaci pomocí kódu). Výhodou zadávání kódem by v budoucnu mohlo být provázání s již zadanými informacemi v NIS, Indikující lékař by tedy reálně tyto informace zadávat podruhé nemusel.

**Platba**

Tato část umožňuje upřesnění, pokud je část vyšetření hrazena jinak než většina (např. speciální rekonstrukce nehrazené pojištěním). I když je vyžadováno, aby byla tato část přítomna, není povinné ji vyplňovat, což znamená, že může být ponecháno prázdné, pokud to není možné.

Volný textový komentář k úhradě lze použít v případě potřeby upřesnit, kterou část péče hradí jiný plátce. To umožňuje jasnost a transparentnost, pokud jde o finanční odpovědnost a ujednání související s poskytovanými zdravotnickými službami.

**Termín vyšetření (návštěvy)**

Tato požadovaná sekce zahrnuje potvrzené informace z vyšetřujícího ZZ o objednávce, tj. na kdy je pacient objednán, kam má přijít, včetně volného textu komentáře (např. MR na 2. patře hlavní budovy). Využití těchto struktur předpokládá, že bude možné po přijetí žádanky vyšetřujícím ZZ tyto informace „doplnit“ neboli vytvořit aktualizovanou verzi žádanky tuto informaci obsahující.

**Objednávky plánované péče**

Odkazy na objednávky plánované péče navazující na tuto žádanku. Kromě ID by měl obsahovat i název této schůzky, ostatní informace by se měly automaticky doplnit z odkazované objednávky. Například “Konzultace na neurochirurgii”, přes ID pak zjistit, že bude v ÚVN 15.3.2040 v 16:15.

**Implantáty**

V této sekci je uveden seznam implantátů či pomůcek majících vliv na průběh vyšetření či jeho interpretaci.

**Přílohy**

Tato požadovaná sekce umožní přidat libovolný další zdroj informací (například ambulantní zprávy, propouštěcí zprávy – v digitální podobě nebo i jen scan, data poskytnutá pacientem atd. Opět není povinná, pouze otevíráme možnost libovolné přílohy).

