# Artifacts - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* **Artifacts**

## Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md) | Žádanka obrazového vyšetření |
| [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md) | Záhlaví dokumentu s administrativními údaji |
| [A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-logSubjectCz.md) | Identifikace pacienta a kontaktní informace pacienta |
| [A.1.3 - Zdravotní pojištění](StructureDefinition-logPayerCz.md) | Informace o zdravotním pojištění. |
| [A.1.4 - Úhrada](StructureDefinition-logCoverageOrderCz.md) | Informace o způsobu úhrady objednávky vyšetření |
| [A.1.5 - Objednatel](StructureDefinition-logAuthorCz.md) | Objednatel (Objednatel provedení zdravotní služby). |
| [A.1.6 - Zpracovatel](StructureDefinition-logRequestedPerformerCz.md) | Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden). |
| [A.1.7 - Příjemce nálezu](StructureDefinition-logAdditionalRecipientCz.md) | Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele) |
| [A.1.8 - Metadata dokumentu](StructureDefinition-logDocumentMetadataCz.md) | Metadata dokumentu |
| [A.1.9 - Elektronické podpisy](StructureDefinition-logdigitalSignatureCz.md) | Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a |
| [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md) | Tělo dokumentu |
| [A.2.1 - Informace o objednávce and A.2.2 - Odůvodnění vyšetření (důvod objednávky)](StructureDefinition-logImageOrderInformationCz.md) | Informace o objednávce a Odůvodnění vyšetření (důvod objednávky) |
| [A.2.3 - Klinická událost (encounter)](StructureDefinition-logClinicalEventCz.md) | Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu) |
| [A.2.4 - Úhrada](StructureDefinition-logCoverageBodyCz.md) | Informace o způsobu úhrady objednávky vyšetření |
| [A.2.5 - Termín návštěvy](StructureDefinition-logImageAppointmentCz.md) | Informace o objednaném termínu vyšetření (pokud byl termín rezervován) |
| [A.2.6 - Informace o vzorku](StructureDefinition-logSpecimenInformationCz.md) | Pro specifická obrazová vyšetření vzorku |
| [A.3.1 - Klinické informace](StructureDefinition-logImageSupportingInformationCz.md) | Informace a údaje sdělované pracovišti zobrazovacích metod, mající vliv na provedení objednávky či interpretaci výsledků vyšetření |
| [A.3.2 - Datové elementy objednávky / vyšetření](StructureDefinition-logOrderDataElementsCz.md) | Datové elementy objednávky / vyšetření |
| [A.3.3 - Objednávky plánované péče](StructureDefinition-logPlannedCareOrdersCz.md) | Odkazy na objednávky plánované péče navazující na tuto žádanku |
| [A.3.4 - Další podpůrné informace](StructureDefinition-logOtherSupportingInformationCz.md) | Ostatní podpůrné informace |
| [A.4 - Vizuální podoba dokumentu](StructureDefinition-logPresentedFormCz.md) | Žádanka obrazového vyšetření čitelná lidským okem, je požadován PDF formát. |
| [A.5 - Přílohy](StructureDefinition-logAttachmentsCz.md) | Ostatní přílohy. |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Imaging Order](StructureDefinition-ImagingOrderCz.md) | Imaging Order |
| [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md) | Imaging Order - Imaging Order header data element - A.1 |
| [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) | Imaging Order - Imaging Order subject data element - A.1.1 and A.1.2 |
| [A.1.3 - Health insurance and payment information](StructureDefinition-PayerCz.md) | Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care. |
| [A.1.4 - Information about coverage](StructureDefinition-CoverageOrderCz.md) | Coverage information - Information about method of coverage, payer identification data and additional information |
| [A.1.5 - Author](StructureDefinition-AuthorCz.md) | Author (by whom the Imaging order was/were authored). Multiple authors could be provided. |
| [A.1.6 - Requested Performer (processing person)](StructureDefinition-RequestedPerformerCz.md) | Person who is requested to process document. |
| [A.1.7 - Additional Recipient](StructureDefinition-AdditionalRecipientCz.md) | Additional Recipient (Additional recipients of the finding in addition to the author) |
| [A.1.8 - Document metadata](StructureDefinition-DocumentMetadataCz.md) | Document metadata |
| [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md) | Digital signature - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md) | Body Imaging Order |
| [A.2.1 - Order information and A.2.2 - Order reason](StructureDefinition-ImageOrderInformationCz.md) | Information about order and order reason |
| [A.2.3 - Clinical event (Encounter)](StructureDefinition-ClinicalEventCz.md) | Clinical event (Encounter) - Information about the clinical event to which the order relates |
| [A.2.4 - Information about additional coverage](StructureDefinition-CoverageBodyCz.md) | Additional coverage information - Information about method of coverage, payer identification data and additional information |
| [A.2.5 - Appointment](StructureDefinition-ImageAppointmentCz.md) | Appointment - Links to planned care order related to this request form |
| [A.2.6 - Specimen Information](StructureDefinition-SpecimenInformationCz.md) | Information about specimen |
| [A.3.1 - Supporting Information](StructureDefinition-ImageSupportingInformationCz.md) | Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results |
| [A.3.2 - Order Data Elements](StructureDefinition-OrderDataElementsCz.md) | Order Data Elements - Order/examination data elements |
| [A.3.3 - Planned Care Orders](StructureDefinition-PlannedCareOrdersCz.md) | Planned Care Orders - Links to planned care orders related to this request form |
| [A.3.4 - Other Supporting Information](StructureDefinition-OtherSupportingInformationCz.md) | Other Supporting Information - Links to other supporting information related to this request form |
| [A.4 - Presented form](StructureDefinition-PresentedFormCz.md) | Presented form - Entire order as issued. Various formats could be provided, pdf format is recommended. |
| [A.5 - Attachments](StructureDefinition-AttachmentsCz.md) | Additional attachments. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Appointment: Imaging Order (CZ)](StructureDefinition-cz-appointment.md) | Czech profile for appointment. |
| [Body Height: Imaging Order (CZ)](StructureDefinition-cz-bodyheight.md) | Profile of body height for the scope of the Czech national interoperability project. |
| [Body Weight: Imaging Order (CZ)](StructureDefinition-cz-bodyweight.md) | Profile of body weight for the scope of the Czech national interoperability project. |
| [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md) | Clinical document used to represent a Imaging Order for the scope of this guide. |
| [Care plan: Imaging Order (CZ)](StructureDefinition-cz-carePlanImage.md) | Care plan for Imaging Order for the scope of the Czech national interoperability project. |
| [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md) | Clinical document used to represent a Imaging Order for the scope of this guide. |
| [Condition: Clinical question (CZ)](StructureDefinition-cz-conditionClinicalQuestion.md) | Condition for purpose of clinical question in Imaging Order for the scope of the Czech national interoperability project. |
| [Condition: Imaging Order (CZ)](StructureDefinition-cz-conditionImage.md) | Condition for Imaging Order for the scope of the Czech national interoperability project. |
| [Device Use Statement: Imaging Order (CZ)](StructureDefinition-cz-deviceUseStatement.md) | This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the imaging order as an instance of a Device resource constrained by this profile. |
| [Flag: Imaging Order (CZ)](StructureDefinition-cz-flag.md) | Czech profile for flag. |
| [Observation: Imaging Order (CZ)](StructureDefinition-cz-observationImage.md) | Observation for Imaging Order for the scope of the Czech national interoperability project. |
| [Patient mobility: Imaging Order (CZ)](StructureDefinition-cz-potientMobility.md) | Profile of patient mobility observation for the scope of the Czech national interoperability project. |
| [Service Request: Imaging Order (CZ)](StructureDefinition-cz-imagingOrderInformation.md) | Order information for the scope of the Czech national interoperability project. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [CZ Composition Type](ValueSet-cz-composition-type-vs.md) | This value set includes all imaging composition types. |
| [CZ Diagnosis Condition](ValueSet-cz-diagnosis-condition-vs.md) | ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes. |
| [CZ Imaging Procedure](ValueSet-cz-imaging-procedure-vs.md) | ValueSet for imaging procedure in the Czech Imaging project, using SNOMED CT. |
| [CZ Mobility Type](ValueSet-cz-mobility-type.md) | This value set includes all patient mobility types for imaging order. |
| [CZ Mobility Value](ValueSet-cz-mobility-value.md) | This value set includes all patient im/mobility values for imaging order. |
| [CZ Modality](ValueSet-cz-modality-vs.md) | This value set includes all modalities. |
| [CZ Provision Code](ValueSet-cz-provision-code.md) | ValueSet for provision codes in the Czech Imaging project, using Orphacode. |
| [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-vs.md) | UCUM units for height |
| [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-vs.md) | UCUM units for weight |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Attachment Model to this guide Map](ConceptMap-AttachmentImagingOrder2FHIR-cz.md) | CZ Imaging Order Attachment Model to this guide mapping |
| [CZ Body Model to this guide Map](ConceptMap-BodyImagingOrder2FHIR-cz.md) | CZ Imaging Order Body Model to this guide mapping |
| [CZ Header Model to this guide Map](ConceptMap-HeaderImagingOrder2FHIR-cz.md) | CZ Imaging Order Header Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AppointmentExample](Appointment-AppointmentExample.md) | Appointment |
| [Body height of patient](Observation-ExampleBodyHeight.md) | Example of body height of Patient Mracena |
| [Body height of patient Kralik](Observation-4a38a57a-fdfe-48df-802c-8d7e8e3e1a3b.md) | Example of body height of Patient Kralik |
| [Body weight of patient](Observation-ExampleBodyWeight.md) | Example of body weight of Patient Mracena |
| [Body weight of patient Kralik](Observation-e0861d9f-4b04-465f-b15b-cb01e3a8b677.md) | Example of body weight of Patient Kralik |
| [Bundle: RTG Patient Kralik](Bundle-BundleKralikRTG.md) | Example of Imaging order (Bundle) including a RTG order |
| [CarePlanExample](CarePlan-CarePlanExample.md) | Care Plan |
| [Coverage - Healthcare insurance company](Coverage-92fcdc96-95c0-4cc9-9857-afee3bed913c.md) | Example of coverage |
| [Example Device - Implantable Pacemaker](Device-711e1d43-d5e4-4cbc-b546-74059db270f6.md) | A sample Device resource for an implantable pacemaker, referenced in a DeviceUseStatement. |
| [Example DeviceUseStatement for Implant](DeviceUseStatement-b29cacfd-b05b-44cf-be5a-8b6d76bdc375.md) | A DeviceUseStatement documenting the use of an implanted pacemaker in the imaging order. |
| [Imaging Order - Rentgen Ing. Králíka](Composition-dbd426a9-d660-4f97-8656-1e39db4a57c9.md) | Example of Imaging order (Composition) including a RTG order |
| [Imaging order for Plain X-ray](ServiceRequest-158808ba-fcca-480e-8188-dec77920ec3c.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-210db397-977a-47a0-8a2e-febde6f9f92a.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-5ab3e344-4d0c-4786-bab2-7dd0d7b60cd9.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-c8d7d3d8-9007-45a7-8f09-0ae69f7d7fed.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-d6784779-d008-447d-90cf-89d5d53a0f04.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-ded5bee9-8a58-4676-919f-0b8e08eaede4.md) | Imaging order for Plain X-ray |
| [Imaging order for Plain X-ray](ServiceRequest-fea1dbb8-9e16-4e11-beae-c12829c97381.md) | Imaging order for Plain X-ray |
| [LocationExample](Location-LocationExample.md) | Example of location |
| [MRDevice](Device-MRDevice.md) | Magnetic Resonance device |
| [Mracena](Patient-Mracena.md) | Patient, contact information and practitioner |
| [Organization - Healthcare insurance company](Organization-35e78cc9-6fe2-42a8-8553-83a3f86ce308.md) | Example of insurance organisation |
| [Patient Kralik](Patient-dd800c46-f71a-4628-b457-6ccaa27dd6bc.md) | Patient, contact information |
| [Patient mobility of patient Kralik](Observation-d70a725d-baa9-4553-a670-2609b0c0219f.md) | Example of patient mobility of Patient Kralik |
| [Practitioner Role Radiology](PractitionerRole-f0ac1e16-61f5-4591-a7eb-1dc586e25349.md) | Author of RTG Imaging report |
| [RGDevice](Device-e33c93c6-3dd0-4595-9f15-63b9302861d1.md) | Radiographic imaging device |
| [Reason in code form](Condition-8ca719d9-da84-4bc0-a7da-860eac1347ce.md) | Condition |
| [cz-encounter-example](Encounter-db16a37b-d393-4767-bb2e-739f9bff16f9.md) | Encounter |
| [cz-imagingorder-example](ServiceRequest-cz-imagingorder-example.md) | Imaging order for Magnetic Resonance |
| [cz-organizationwithlogo-example](Organization-5bdedd9b-27c5-4593-ae3a-968c5f25d253.md) | An example of the organization with logo extension |
| [cz-practitioner1-example](Practitioner-16793b99-aecc-482d-8283-0e4885e0ca25.md) | Example of practitioner |
| [cz-practitioner2-example](Practitioner-984dcf34-1924-45a8-8ec5-3d100b67d9be.md) | Example of practitioner |
| [logoFNOblackov-example](DocumentReference-0af43461-495e-4dfc-82ca-7f3140a60fe7.md) | Example of logo as document reference for FN Obláčkov. |
| [practitionerExample](Practitioner-practitionerExample.md) | Example of practitioner |

### Other 

These are resources that are used within this implementation guide that do not fit into one of the other categories.

| | |
| :--- | :--- |
| [expansion](Parameters-expansion.md) | SNOMED CT Czech expansion parameter |

