# CZ Modality - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Modality**

## ValueSet: CZ Modality 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ValueSet/cz-modality-vs | *Version*:0.1.0-ballot |
| Active as of 2019-03-27 | *Computable Name*:CZ_ModalityVs |

 
This value set includes all modalities. 

 **References** 

* [Service Request: Imaging Order (CZ)](StructureDefinition-cz-imagingOrderInformation.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-modality-vs",
  "language" : "cs",
  "url" : "https://hl7.cz/fhir/img-order/ValueSet/cz-modality-vs",
  "version" : "0.1.0-ballot",
  "name" : "CZ_ModalityVs",
  "title" : "CZ Modality",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-27",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This value set includes all modalities.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://dicom.nema.org/resources/ontology/DCM",
        "version" : "2022.4.20221006",
        "concept" : [
          {
            "code" : "AR",
            "display" : "Autorefraction"
          },
          {
            "code" : "BI",
            "display" : "Biomagnetic Imaging"
          },
          {
            "code" : "BMD",
            "display" : "Bone Mineral Densitometry"
          },
          {
            "code" : "CR",
            "display" : "Computed Radiography"
          },
          {
            "code" : "CT",
            "display" : "Computed Tomography"
          },
          {
            "code" : "DMS",
            "display" : "Dermoscopy"
          },
          {
            "code" : "DG",
            "display" : "Diaphanography"
          },
          {
            "code" : "DX",
            "display" : "Digital Radiography"
          },
          {
            "code" : "ES",
            "display" : "Endoscopy"
          },
          {
            "code" : "XC",
            "display" : "External-camera Photography"
          },
          {
            "code" : "GM",
            "display" : "General Microscopy"
          },
          {
            "code" : "IO",
            "display" : "Intra-oral Radiography"
          },
          {
            "code" : "IVOCT",
            "display" : "Intravascular Optical Coherence Tomography"
          },
          {
            "code" : "IVUS",
            "display" : "Intravascular Ultrasound"
          },
          {
            "code" : "KER",
            "display" : "Keratometry"
          },
          {
            "code" : "LS",
            "display" : "Laser surface scan"
          },
          {
            "code" : "LEN",
            "display" : "Lensometry"
          },
          {
            "code" : "MR",
            "display" : "Magnetic Resonance"
          },
          {
            "code" : "MG",
            "display" : "Mammography"
          },
          {
            "code" : "NM",
            "display" : "Nuclear Medicine"
          },
          {
            "code" : "OAM",
            "display" : "Ophthalmic Axial Measurements"
          },
          {
            "code" : "OPM",
            "display" : "Ophthalmic Mapping"
          },
          {
            "code" : "OP",
            "display" : "Ophthalmic Photography"
          },
          {
            "code" : "OPT",
            "display" : "Ophthalmic Tomography"
          },
          {
            "code" : "OPTBSV",
            "display" : "Ophthalmic Tomography B-scan Volume Analysis"
          },
          {
            "code" : "OPTENF",
            "display" : "Ophthalmic Tomography En Face"
          },
          {
            "code" : "OPV",
            "display" : "Ophthalmic Visual Field"
          },
          {
            "code" : "OCT",
            "display" : "Optical Coherence Tomography"
          },
          {
            "code" : "OSS",
            "display" : "Optical Surface Scanner"
          },
          {
            "code" : "PX",
            "display" : "Panoramic X-Ray"
          },
          {
            "code" : "PT",
            "display" : "Positron emission tomography"
          },
          {
            "code" : "RF",
            "display" : "Radiofluoroscopy"
          },
          {
            "code" : "RG",
            "display" : "Radiographic imaging"
          },
          {
            "code" : "RTIMAGE",
            "display" : "RT Image"
          },
          {
            "code" : "SM",
            "display" : "Slide Microscopy"
          },
          {
            "code" : "SRF",
            "display" : "Subjective Refraction"
          },
          {
            "code" : "TG",
            "display" : "Thermography"
          },
          {
            "code" : "US",
            "display" : "Ultrasound"
          },
          {
            "code" : "BDUS",
            "display" : "Ultrasound Bone Densitometry"
          },
          {
            "code" : "VA",
            "display" : "Visual Acuity"
          },
          {
            "code" : "XA",
            "display" : "X-Ray Angiography"
          }
        ]
      }
    ]
  }
}

```
