# CZ Diagnosis Condition - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Diagnosis Condition**

## ValueSet: CZ Diagnosis Condition 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ValueSet/cz-diagnosis-condition-vs | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_DiagnosisConditionVs |

 
ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes. 

 **References** 

* [Condition: Imaging Order (CZ)](StructureDefinition-cz-conditionImage.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-diagnosis-condition-vs",
  "url" : "https://hl7.cz/fhir/img-order/ValueSet/cz-diagnosis-condition-vs",
  "version" : "0.1.0-ballot",
  "name" : "CZ_DiagnosisConditionVs",
  "title" : "CZ Diagnosis Condition",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "ValueSet for diagnosis in condition in the Czech Imaging project, using MKN-10 and ORPHA codes.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://terminology.uzis.cz/CodeSystem/Mkn10_5"
      },
      {
        "system" : "https://www.orpha.net"
      }
    ]
  }
}

```
