# A.1.9 - Elektronické podpisy - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.9 - Elektronické podpisy**

## Logical Model: A.1.9 - Elektronické podpisy 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logdigitalSignatureCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzDigitalSignatureCz |

 
Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logdigitalSignatureCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logdigitalSignatureCz.csv), [Excel](StructureDefinition-logdigitalSignatureCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logdigitalSignatureCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logdigitalSignatureCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzDigitalSignatureCz",
  "title" : "A.1.9 - Elektronické podpisy",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logdigitalSignatureCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logdigitalSignatureCz",
        "path" : "logdigitalSignatureCz",
        "short" : "A.1.9 - Elektronické podpisy",
        "definition" : "Elektronické podpisy - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a"
      },
      {
        "id" : "logdigitalSignatureCz.elektronickyPodpis",
        "path" : "logdigitalSignatureCz.elektronickyPodpis",
        "short" : "A.1.9.1 - Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "logdigitalSignatureCz.casoveRazitko",
        "path" : "logdigitalSignatureCz.casoveRazitko",
        "short" : "A.1.9.2 - Elektronické časové razítko",
        "definition" : "Elektronické časové razítko ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
