# A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu**

## Logical Model: A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logSubjectCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzSubjectImagingOrderCz |

 
Identifikace pacienta a kontaktní informace pacienta 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logSubjectCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logSubjectCz.csv), [Excel](StructureDefinition-logSubjectCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logSubjectCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSubjectCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzSubjectImagingOrderCz",
  "title" : "A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Identifikace pacienta a kontaktní informace pacienta",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSubjectCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logSubjectCz",
        "path" : "logSubjectCz",
        "short" : "A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu",
        "definition" : "Identifikace pacienta a kontaktní informace pacienta"
      },
      {
        "id" : "logSubjectCz.identifikace",
        "path" : "logSubjectCz.identifikace",
        "short" : "A.1.1 - Identifikace pacienta/subjektu",
        "definition" : "Identifikace pacienta/subjektu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.jmeno",
        "path" : "logSubjectCz.identifikace.jmeno",
        "short" : "A.1.1.1 - Jméno",
        "definition" : "Křestní jméno pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.prijmeni",
        "path" : "logSubjectCz.identifikace.prijmeni",
        "short" : "A.1.1.2 - Příjmení",
        "definition" : "Příjmení pacienta.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.datumNarozeni",
        "path" : "logSubjectCz.identifikace.datumNarozeni",
        "short" : "A.1.1.3 - Datum narození",
        "definition" : "Datum, případně i čas narození.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.datumUmrti",
        "path" : "logSubjectCz.identifikace.datumUmrti",
        "short" : "A.1.1.4 - Datum úmrtí",
        "definition" : "Datum, případně i čas smrti.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.identifikator",
        "path" : "logSubjectCz.identifikace.identifikator",
        "short" : "A.1.1.5 - Identifikátor",
        "definition" : "Typ identifikátoru a identifikátor osoby. Identifikátor musí být unikátní v rámci daného typu identifikátoru. Povinné je zadání alespoň jednoho národního či mezinárodního identifikátoru (rodné číslo, číslo pasu apod.)",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.statniObcanstvi",
        "path" : "logSubjectCz.identifikace.statniObcanstvi",
        "short" : "A.1.1.6 - Státní občanství",
        "definition" : "Státní občanství dle zákona 186/2013. Státní občanství, jak je uváděno na oficiálních dokladech k prokázání identity.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.pohlavi",
        "path" : "logSubjectCz.identifikace.pohlavi",
        "short" : "A.1.1.7 - Pohlaví",
        "definition" : "Úřední/administrativní pohlaví (pohlaví uváděné v dokladech pro úřední účely). Biologické pohlaví pacienta, které může být odlišné od pohlaví administrativního může být vedeno v jiných částech zdravotnické dokumentace.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.pohlaviProKlinickeUcely",
        "path" : "logSubjectCz.identifikace.pohlaviProKlinickeUcely",
        "short" : "A.1.1.8 - Pohlaví pro klinické použití",
        "definition" : "Běžně se uvádí jen pohlaví úřední, pohlaví pro klinické použití je fakultativní - výjimečné. Pokud je vyplněno pracuje se s ním přednostně v klinické praxi - např. při výběru ref. mezí u škál atd.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.komunikacniJazyk",
        "path" : "logSubjectCz.identifikace.komunikacniJazyk",
        "short" : "A.1.1.9 - Komunikační jazyk",
        "definition" : "Jazyk (jazyky) v nichž pacient komunikuje",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.identifikace.handicap",
        "path" : "logSubjectCz.identifikace.handicap",
        "short" : "A.1.1.10 - Handicap",
        "definition" : "Handicap pacienta (hluchý, apod.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt",
        "path" : "logSubjectCz.kontakt",
        "short" : "A.1.2 - Kontaktní informace pacienta",
        "definition" : "Kontaktní informace pacienta",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.adresa",
        "path" : "logSubjectCz.kontakt.adresa",
        "short" : "A.1.2.1 - Adresa",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.telekom",
        "path" : "logSubjectCz.kontakt.telekom",
        "short" : "A.1.2.2 - Telekom",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar",
        "path" : "logSubjectCz.kontakt.preferovanyLekar",
        "short" : "A.1.2.3 - Preferovaný lékař - Registrující praktický lékař, případně jiný lékař, který může poskytovat informace o pacientovi. Zvláště potřebné u pacientů s vzácným onemocněním.",
        "definition" : "A.1.2.3 - Preferovaný lékař - Registrující praktický lékař, případně jiný lékař, který může poskytovat informace o pacientovi. Zvláště potřebné u pacientů s vzácným onemocněním.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.identifikator",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.identifikator",
        "short" : "A.1.2.3.1 - Identifikátor preferovaného lékaře",
        "definition" : "Identifikační číslo zdravotnického pracovníka dle Národního registru zdravotnických pracovníků.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.jmeno",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.jmeno",
        "short" : "A.1.2.3.2 - Jméno preferovaného lékaře",
        "definition" : "Jméno lékaře, u kterého je pacient v péči, nebo který pacienta eviduje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.specializace",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.specializace",
        "short" : "A.1.2.3.3 - Specializace preferovaného lékaře",
        "definition" : "Specializace lékaře (Praktické lékařství pro děti a dorost, Praktické lékařství pro dospělé, interní lékařství, gynekologie a porodnictví apod.)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.organizace",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.organizace",
        "short" : "A.1.2.3.4 - Organizace preferovaného lékaře",
        "definition" : "Identifikátor a název poskytovatele, kterého lékař reprezentuje",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.adresa",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.adresa",
        "short" : "A.1.2.3.5 - Adresa preferovaného lékaře",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.preferovanyLekar.telekom",
        "path" : "logSubjectCz.kontakt.preferovanyLekar.telekom",
        "short" : "A.1.2.3.6 - Telekom preferovaného lékaře",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba",
        "short" : "A.1.2.4 - Zákonní zástupci a další kontaktní osoby",
        "definition" : "Zákonní zástupci a další kontaktní osoby",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.typ",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.typ",
        "short" : "A.1.2.4.1 - Typ kontaktu",
        "definition" : "Typ kontaktní osoby rozlišující emergentní kontakty, zákonné zástupce a ostatní osoby se vztahem k pacientovi.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.vztah",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.vztah",
        "short" : "A.1.2.4.2 - Vztah k pacientovi",
        "definition" : "Vztah osoby k pacientovi (otec, syn, dcera atp.)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.identifikator",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.identifikator",
        "short" : "A.1.2.4.3 - Identifikátor osoby",
        "definition" : "Identifikátor kontaktní osoby",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.jmeno",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.jmeno",
        "short" : "A.1.2.4.4 - Jméno osoby",
        "definition" : "Jméno kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.prijmeni",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.prijmeni",
        "short" : "A.1.2.4.5 - Příjmení osoby",
        "definition" : "Příjmení kontaktní osoby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.adresa",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.adresa",
        "short" : "A.1.2.4.6 - Adresa",
        "definition" : "Poštovní, domácí a/nebo kancelářské adresa. Adresy jsou vždy sekvence částí adresy (např. řádek adresy, země, PSČ, město), i když se formát poštovní adresy může lišit v závislosti na zemi. Adresa může obsahovat informaci o typu adresy; pokud tento atribut není přítomen, předpokládá se, že jde o výchozí adresu použitelnou pro jakýkoli účel.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logSubjectCz.kontakt.kontaktniOsoba.telekom",
        "path" : "logSubjectCz.kontakt.kontaktniOsoba.telekom",
        "short" : "A.1.2.4.7 - Telekom",
        "definition" : "Telekomunikační kontakt (e-mail, telefon atp.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
