# A.4 - Vizuální podoba dokumentu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.4 - Vizuální podoba dokumentu**

## Logical Model: A.4 - Vizuální podoba dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logPresentedFormCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzPresentedFormCz |

 
Žádanka obrazového vyšetření čitelná lidským okem, je požadován PDF formát. 

**Usages:**

* Use this Logical Model: [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logPresentedFormCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logPresentedFormCz.csv), [Excel](StructureDefinition-logPresentedFormCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logPresentedFormCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logPresentedFormCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzPresentedFormCz",
  "title" : "A.4 - Vizuální podoba dokumentu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Žádanka obrazového vyšetření čitelná lidským okem,  je požadován PDF formát.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logPresentedFormCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logPresentedFormCz",
        "path" : "logPresentedFormCz",
        "short" : "A.4 - Vizuální podoba dokumentu",
        "definition" : "Žádanka obrazového vyšetření čitelná lidským okem,  je požadován PDF formát."
      },
      {
        "id" : "logPresentedFormCz.typObsahu",
        "path" : "logPresentedFormCz.typObsahu",
        "short" : "A.4.1 - Typ obsahu",
        "definition" : "Typ obsahu - je  požadován MIME typ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPresentedFormCz.jazyk",
        "path" : "logPresentedFormCz.jazyk",
        "short" : "A.4.2 - Jazyk obsahu",
        "definition" : "Jazyk obsahu - je požadována hodnata z HL7 valueset Languages",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logPresentedFormCz.data",
        "path" : "logPresentedFormCz.data",
        "short" : "A.4.3 - Data obsahu",
        "definition" : "Data v base64",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "base64Binary"
          }
        ]
      },
      {
        "id" : "logPresentedFormCz.url",
        "path" : "logPresentedFormCz.url",
        "short" : "A.4.4 - URL obsahu",
        "definition" : "Uri kde lze data nalézt",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "url"
          }
        ]
      },
      {
        "id" : "logPresentedFormCz.nazev",
        "path" : "logPresentedFormCz.nazev",
        "short" : "A.4.5 - Název obsahu",
        "definition" : "Titulek, který bude zobrazen před daty",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logPresentedFormCz.vytvoreni",
        "path" : "logPresentedFormCz.vytvoreni",
        "short" : "A.4.6 - Datum vytvoření",
        "definition" : "Datum, kdy byl obsah poprvé vytvořen",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      }
    ]
  }
}

```
