# A - Žádanka obrazového vyšetření - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Žádanka obrazového vyšetření**

## Logical Model: A - Žádanka obrazového vyšetření 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logImagingOrderCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzImagingOrderCz |

 
Žádanka obrazového vyšetření 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logImagingOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logImagingOrderCz.csv), [Excel](StructureDefinition-logImagingOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logImagingOrderCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImagingOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzImagingOrderCz",
  "title" : "A - Žádanka obrazového vyšetření",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Žádanka obrazového vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImagingOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logImagingOrderCz",
        "path" : "logImagingOrderCz",
        "short" : "A - Žádanka obrazového vyšetření",
        "definition" : "Žádanka obrazového vyšetření"
      },
      {
        "id" : "logImagingOrderCz.hlavicka",
        "path" : "logImagingOrderCz.hlavicka",
        "short" : "A.1 -  Hlavička žádanky obrazového vysetreni",
        "definition" : "Hlavička žádanky obrazového vysetreni",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logHeaderImagingOrder"
          }
        ]
      },
      {
        "id" : "logImagingOrderCz.telo",
        "path" : "logImagingOrderCz.telo",
        "short" : "A.2 a A.3 - Tělo žádanky obrazového vyšetření",
        "definition" : "Tělo žádanky obrazového vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logBodyImageOrderCz"
          }
        ]
      },
      {
        "id" : "logImagingOrderCz.presentacniForma",
        "path" : "logImagingOrderCz.presentacniForma",
        "short" : "A.4 - Vizuální podoba dokumentu",
        "definition" : "Žádanka obrazového vyšetření čitelná lidským okem,  je požadován PDF formát.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logPresentedFormCz"
          }
        ]
      },
      {
        "id" : "logImagingOrderCz.prilohy",
        "path" : "logImagingOrderCz.prilohy",
        "short" : "A.5 - Přílohy",
        "definition" : "Ostatní přílohy",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
