# A.2.5 - Termín návštěvy - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.5 - Termín návštěvy**

## Logical Model: A.2.5 - Termín návštěvy 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logImageAppointmentCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogCzImageAppointmentCz |

 
Informace o objednaném termínu vyšetření (pokud byl termín rezervován) 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logImageAppointmentCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logImageAppointmentCz.csv), [Excel](StructureDefinition-logImageAppointmentCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logImageAppointmentCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageAppointmentCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzImageAppointmentCz",
  "title" : "A.2.5 - Termín návštěvy",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace o objednaném termínu vyšetření (pokud byl termín rezervován)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logImageAppointmentCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logImageAppointmentCz",
        "path" : "logImageAppointmentCz",
        "short" : "A.2.5 - Termín návštěvy",
        "definition" : "Informace o objednaném termínu vyšetření (pokud byl termín rezervován)"
      },
      {
        "id" : "logImageAppointmentCz.id",
        "path" : "logImageAppointmentCz.id",
        "short" : "A.2.5.1 - Termín ID",
        "definition" : "Identifikátor záznamu termínu návštěvy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.stav",
        "path" : "logImageAppointmentCz.stav",
        "short" : "A.2.5.2 - Stav termínu",
        "definition" : "Stav termínu (navržený, potvrzený, zrušený).\nPreferovaný systém: hl7:valueset-appointmentstatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.popis",
        "path" : "logImageAppointmentCz.popis",
        "short" : "A.2.5.3 - Popis",
        "definition" : "Stručný popis termínu návštěvy pro zobrazení v seznamu termínů.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.datumACas",
        "path" : "logImageAppointmentCz.datumACas",
        "short" : "A.2.5.4 - Plánovaný čas",
        "definition" : "Datum a čas návštěvy",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.delkaVysetreni",
        "path" : "logImageAppointmentCz.delkaVysetreni",
        "short" : "A.2.5.5 - Délka vyšetření",
        "definition" : "Délka vyšetření",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.komentar",
        "path" : "logImageAppointmentCz.komentar",
        "short" : "A.2.5.6 - Komentář",
        "definition" : "Doplňující komentář",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.instrukceProPacienta",
        "path" : "logImageAppointmentCz.instrukceProPacienta",
        "short" : "A.2.5.7 - Instrukce pro pacienta",
        "definition" : "Instrukce pro pacienta (např. dostavte se 15 minut napřed, nalačno, zajistěte si odvoz apod.).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "logImageAppointmentCz.misto",
        "path" : "logImageAppointmentCz.misto",
        "short" : "A.2.5.8 - Místo",
        "definition" : "Název a adresa pracoviště, kde byl termín návštěvy sjednán.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
