# A.1 - Hlavička dokumentu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Hlavička dokumentu**

## Logical Model: A.1 - Hlavička dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logHeaderImagingOrder | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogCzHeaderImagingOrderCz |

 
Záhlaví dokumentu s administrativními údaji 

**Usages:**

* Use this Logical Model: [A - Žádanka obrazového vyšetření](StructureDefinition-logImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logHeaderImagingOrder)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logHeaderImagingOrder.csv), [Excel](StructureDefinition-logHeaderImagingOrder.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logHeaderImagingOrder",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logHeaderImagingOrder",
  "version" : "0.1.0-ballot",
  "name" : "LogCzHeaderImagingOrderCz",
  "title" : "A.1 - Hlavička dokumentu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Záhlaví dokumentu s administrativními údaji",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logHeaderImagingOrder",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logHeaderImagingOrder",
        "path" : "logHeaderImagingOrder",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Záhlaví dokumentu s administrativními údaji"
      },
      {
        "id" : "logHeaderImagingOrder.subjekt",
        "path" : "logHeaderImagingOrder.subjekt",
        "short" : "A.1.1 - Identifikace pacienta and A.1.2 Kontaktní informace pacienta/subjektu",
        "definition" : "Identifikace pacienta/subjektu a jeho kontaktních informací",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logSubjectCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.zdravotniPojisteni",
        "path" : "logHeaderImagingOrder.zdravotniPojisteni",
        "short" : "A.1.3 - Zdravotní pojištění",
        "definition" : "Informace o zdravotním pojištění.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logPayerCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.uhrada",
        "path" : "logHeaderImagingOrder.uhrada",
        "short" : "A.1.4 - Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageOrderCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.objednatel",
        "path" : "logHeaderImagingOrder.objednatel",
        "short" : "A.1.5 - Objednatel",
        "definition" : "Objednatel provedení zdravotní služby.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAuthorCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.zpracovatel",
        "path" : "logHeaderImagingOrder.zpracovatel",
        "short" : "A.1.6 - Zpracovatel",
        "definition" : "Předpokládaný zpracovatel žádanky (u neadresné žádanky nebude zpracovatel uveden).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logRequestedPerformerCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.dodatecniPrijemci",
        "path" : "logHeaderImagingOrder.dodatecniPrijemci",
        "short" : "A.1.7 - Příjemce nálezu",
        "definition" : "Dodateční příjemci nálezu kromě objednatele",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAdditionalRecipientCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.metadataDokumentu",
        "path" : "logHeaderImagingOrder.metadataDokumentu",
        "short" : "A.1.8 - Metadata dokumentu",
        "definition" : "Dokument metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logDocumentMetadataCz"
          }
        ]
      },
      {
        "id" : "logHeaderImagingOrder.elektronickyPodpis",
        "path" : "logHeaderImagingOrder.elektronickyPodpis",
        "short" : "A.1.9 - Elektronické podpisy",
        "definition" : "Elektronické podpisy dle zákona 327/2011 §54a",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/logdigitalSignatureCz"
          }
        ]
      }
    ]
  }
}

```
