# A.1.4 - Úhrada - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.4 - Úhrada**

## Logical Model: A.1.4 - Úhrada 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageOrderCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzCoverageOrderCz |

 
Informace o způsobu úhrady objednávky vyšetření 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logCoverageOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logCoverageOrderCz.csv), [Excel](StructureDefinition-logCoverageOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logCoverageOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzCoverageOrderCz",
  "title" : "A.1.4 - Úhrada",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace o způsobu úhrady objednávky vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logCoverageOrderCz",
        "path" : "logCoverageOrderCz",
        "short" : "A.1.4 - Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření"
      },
      {
        "id" : "logCoverageOrderCz.method",
        "path" : "logCoverageOrderCz.method",
        "short" : "A.1.4.1 - Způsob úhrady",
        "definition" : "Způsob úhrady objednávky (zdravotní pojištění, hradí pacient, jiný).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci",
        "path" : "logCoverageOrderCz.infoOPlatci",
        "short" : "A.1.4.2 - Informace o plátci",
        "definition" : "Identifikační údaje plátce a doplňující informace, pokud jde o jinou úhradu než ze zdravotního pojištění. Identifikační údaje obsahují identifikátor, název organizace či jméno plátce, adresu plátce a telekomunikační spojení.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.jmeno",
        "path" : "logCoverageOrderCz.infoOPlatci.jmeno",
        "short" : "A.1.4.2.1 - Jméno plátce",
        "definition" : "Jméno a příjmení plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.idOrganizace",
        "path" : "logCoverageOrderCz.infoOPlatci.idOrganizace",
        "short" : "A.1.4.2.2 - ID organizace",
        "definition" : "Identifikátor organizace plátce",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.organizace",
        "path" : "logCoverageOrderCz.infoOPlatci.organizace",
        "short" : "A.1.4.2.3 - Organizace plátce",
        "definition" : "Organizace plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.adresa",
        "path" : "logCoverageOrderCz.infoOPlatci.adresa",
        "short" : "A.1.4.2.4 - Adresa",
        "definition" : "Adresa plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.zeme",
        "path" : "logCoverageOrderCz.infoOPlatci.zeme",
        "short" : "A.1.4.2.5 - Země",
        "definition" : "Země plátce",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logCoverageOrderCz.infoOPlatci.telekom",
        "path" : "logCoverageOrderCz.infoOPlatci.telekom",
        "short" : "A.1.4.2.6 - Telekom",
        "definition" : "Telekomunikační spojení na plátce.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
