# A.2.4 - Úhrada - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.4 - Úhrada**

## Logical Model: A.2.4 - Úhrada 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageBodyCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzCoverageBodyCz |

 
Informace o způsobu úhrady objednávky vyšetření 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logCoverageBodyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logCoverageBodyCz.csv), [Excel](StructureDefinition-logCoverageBodyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logCoverageBodyCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageBodyCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzCoverageBodyCz",
  "title" : "A.2.4 - Úhrada",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace o způsobu úhrady objednávky vyšetření",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logCoverageBodyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logCoverageBodyCz",
        "path" : "logCoverageBodyCz",
        "short" : "A.2.4 - Úhrada",
        "definition" : "Informace o způsobu úhrady objednávky vyšetření"
      },
      {
        "id" : "logCoverageBodyCz.zpusob",
        "path" : "logCoverageBodyCz.zpusob",
        "short" : "A.2.4.1 - Způsob úhrady",
        "definition" : "Method of payment for the order (health insurance, paid by the patient, other)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci",
        "path" : "logCoverageBodyCz.infoOPlatci",
        "short" : "A.2.4.2 - Informace o plátci",
        "definition" : "Payer identification data and additional information regarding reimbursement other than from health insurance. Identification data includes the identifier, name of the organization or name of the payer, address of the payer and telecommunications connection.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.jmeno",
        "path" : "logCoverageBodyCz.infoOPlatci.jmeno",
        "short" : "A.2.4.2.1 - Jméno plátce",
        "definition" : "Jméno a příjmení plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.idOrganizace",
        "path" : "logCoverageBodyCz.infoOPlatci.idOrganizace",
        "short" : "A.2.4.2.2 - ID organizace plátce",
        "definition" : "Identifikátor organizace plátce",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.organizace",
        "path" : "logCoverageBodyCz.infoOPlatci.organizace",
        "short" : "A.2.4.2.3 - Organizace plátce",
        "definition" : "Organizace plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.adresa",
        "path" : "logCoverageBodyCz.infoOPlatci.adresa",
        "short" : "A.2.4.2.4 - Adresa",
        "definition" : "Adresa plátce",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.zeme",
        "path" : "logCoverageBodyCz.infoOPlatci.zeme",
        "short" : "A.2.4.2.5 - Země",
        "definition" : "Země, ze které úhrada pochází",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.infoOPlatci.telekom",
        "path" : "logCoverageBodyCz.infoOPlatci.telekom",
        "short" : "A.4.7.2.6 - Telekom",
        "definition" : "Telekomunikační spojení na osobu zodpovědnou za úhrady.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "logCoverageBodyCz.komentar",
        "path" : "logCoverageBodyCz.komentar",
        "short" : "A.2.4.3 - Komentář",
        "definition" : "Případné upřesnění platby",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
