# A.2.3 - Klinická událost (encounter) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Klinická událost (encounter)**

## Logical Model: A.2.3 - Klinická událost (encounter) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logClinicalEventCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogCzClinicalEventCz |

 
Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu) 

**Usages:**

* Use this Logical Model: [A.2 a A.3 - Tělo dokumentu](StructureDefinition-logBodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logClinicalEventCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logClinicalEventCz.csv), [Excel](StructureDefinition-logClinicalEventCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logClinicalEventCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logClinicalEventCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzClinicalEventCz",
  "title" : "A.2.3 - Klinická událost (encounter)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logClinicalEventCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logClinicalEventCz",
        "path" : "logClinicalEventCz",
        "short" : "A.2.3 - Klinická událost (encounter)",
        "definition" : "Informace o klinické události, ke které se objednávka vztahuje (odkaz na návštěvu)"
      },
      {
        "id" : "logClinicalEventCz.identifikator",
        "path" : "logClinicalEventCz.identifikator",
        "short" : "A.2.3.1 - ID klinické události",
        "definition" : "Jednoznačný, globálně unikátní identifikátor klinické události, k němuž se objednávka vztahuje.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logClinicalEventCz.typ",
        "path" : "logClinicalEventCz.typ",
        "short" : "A.2.3.2 - Typ klinické události",
        "definition" : "Typ klinické události dle číselníku typů. (např. hospitalizace, ambulantní návštěva apod.).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logClinicalEventCz.dalsiInformace",
        "path" : "logClinicalEventCz.dalsiInformace",
        "short" : "A.2.3.3 - Další informace o klinické události",
        "definition" : "Typ poskytovaných služeb, období či délka klinické události, vazba na další klinické události apod.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
