# A.1.7 - Příjemce nálezu - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.7 - Příjemce nálezu**

## Logical Model: A.1.7 - Příjemce nálezu 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/logAdditionalRecipientCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzAdditionalRecipient |

 
Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele) 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-logHeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/logAdditionalRecipientCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logAdditionalRecipientCz.csv), [Excel](StructureDefinition-logAdditionalRecipientCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logAdditionalRecipientCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAdditionalRecipientCz",
  "version" : "0.1.0-ballot",
  "name" : "LogCzAdditionalRecipient",
  "title" : "A.1.7 - Příjemce nálezu",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele)",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/logAdditionalRecipientCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logAdditionalRecipientCz",
        "path" : "logAdditionalRecipientCz",
        "short" : "A.1.7 - Příjemce nálezu",
        "definition" : "Příjemce nálezu (Dodateční příjemci nálezu kromě objednatele)"
      },
      {
        "id" : "logAdditionalRecipientCz.identifikator",
        "path" : "logAdditionalRecipientCz.identifikator",
        "short" : "A.1.7.1 - Identifikátor příjemce",
        "definition" : "I Identifikátor, který se vztahuje na tuto osobu v této roli.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logAdditionalRecipientCz.jmeno",
        "path" : "logAdditionalRecipientCz.jmeno",
        "short" : "A.1.7.2 - Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "logAdditionalRecipientCz.idOrganizace",
        "path" : "logAdditionalRecipientCz.idOrganizace",
        "short" : "A.1.7.3 - ID organizace",
        "definition" : "Identifikátor organizace příjemce nálezu, který se používá k identifikaci organizace v různých informačních systémech.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "logAdditionalRecipientCz.organizace",
        "path" : "logAdditionalRecipientCz.organizace",
        "short" : "A.1.7.4 - Organizace příjemce",
        "definition" : "Název, identifikační a kontaktní údaje zdravotnického zařízení příjemce, případně také pracoviště příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
