# Condition: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Condition: Imaging Order (CZ)**

## Resource Profile: Condition: Imaging Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_ConditionImage |

 
Condition for Imaging Order for the scope of the Czech national interoperability project. 

**Usages:**

* Derived from this Profile: [Condition: Clinical question (CZ)](StructureDefinition-cz-conditionClinicalQuestion.md)
* Use this Profile: [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* Examples for this Profile: [Condition/8ca719d9-da84-4bc0-a7da-860eac1347ce](Condition-8ca719d9-da84-4bc0-a7da-860eac1347ce.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-conditionImage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-conditionImage.csv), [Excel](StructureDefinition-cz-conditionImage.xlsx), [Schematron](StructureDefinition-cz-conditionImage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-conditionImage",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage",
  "version" : "0.1.0-ballot",
  "name" : "CZ_ConditionImage",
  "title" : "Condition: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Condition for Imaging Order for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-category"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "mustSupport" : true
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Condition.code.coding:diagnosis",
        "path" : "Condition.code.coding",
        "sliceName" : "diagnosis",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://hl7.cz/fhir/img-order/ValueSet/cz-diagnosis-condition-vs"
        }
      },
      {
        "id" : "Condition.code.coding:condition",
        "path" : "Condition.code.coding",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Condition.code.coding:condition.system",
        "path" : "Condition.code.coding.system",
        "fixedUri" : "http://snomed.info/sct"
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ]
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      },
      {
        "id" : "Condition.asserter",
        "path" : "Condition.asserter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core"
            ]
          }
        ]
      }
    ]
  }
}

```
