# Composition: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition: Imaging Order (CZ)**

## Resource Profile: Composition: Imaging Order (CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_CompositionImageOrder |
| **Copyright/Legal**: HL7 CZ | | |

 
Clinical document used to represent a Imaging Order for the scope of this guide. 

 
Imaging order bundle is an electronic health record extract containing order for imaging observation from a subject of care, comprising at least the required elements of the imaging dataset. 

## Content (cs)

### Sekce a obsah

Dokument je rozdělen do sady povinných a nepovinných sekcí. V případě, že nejsou pro povinnou sekci k dispozici žádná data, lze odůvodnění vyjádřit v `composition.section.emptyReason`.

### Struktura dokumentu

Zobrazovací zpráva obsahuje následující sekce v tomto pořadí:

#### Hlavička obrazové žádanky

Obecné informace o zprávě. Většina informačních prvků v této části zprávy se překrývá s jinými klinickými zprávami. Záhlaví dokumentu obsahuje informace o pacientovi, zdrojové organizaci, autorovi, ověřovateli a správci zprávy.

**Klinická událost (encounter)**

Tento profil umožňuje propojení žádanky s jednou konkrétní klinickou událostí, tj. například návštěvu ambulance, při které žádanka vznikla.

#### Tělo obrazové žádanky

**Informace o objednávce**

Tato požadovaná sekce zahrnuje povinný identifikátor žádanky ([A.2.1.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.identifier)), datum a čas jejího vytvoření ([A.2.1.2](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.dateTime)) – pokud je založena sekce informací, musí tyto informace obsahovat. Mezi volitelné položky patří urgentnost objednávky (z pohledu indikujícího lékaře) vyjádřená mezinárodním kódem ze sytému HL7 ([Request Priority](https://hl7.org/fhir/valueset-request-priority.html)) ([A.2.1.4](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.urgency)), který může nabývat hodnot routine (běžná priorita), urgent (spěchá), asap (co možná nejdříve) a stat (status iminens, STATIM). Další volitelnou položkou je datum a čas požadovaného vyšetření ([A.2.1.3](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.requestedExecdateTime)), zde se nejedná o termín skutečného objednání, otevírá se zde možnost např. zaslat žádanku s prosbou o objednání na den, kdy má pacient ambulantní klinickou kontrolu.

Další požadavky / podrobné specifikace zkoušky ([A.2.1.5](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.orderText)) je další volitelné pole, které může obsahovat další informace pro objednávku. To může zahrnovat například požadavek odesílajícího lékaře na použití specifického dohodnutého protokolu nebo provedení vyšetření na konkrétním přístroji MRI.

Poslední volitelnou položkou jsou informace pro pacienta, jako jsou požadavky na lačno, vysazení léků, rady ohledně klaustrofobie atd.

**Odůvodnění vyšetření (klinická otázka)**

Tato požadovaná sekce zahrnuje indikační diagnózu ([A.2.2.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderReason.problem)), která je vyžadována zdravotními pojišťovnami k proplacení služby. Další položky zahrnují klinickou otázku (věta tázací, měla by končit otazníkem a mělo by možné na ni na základě obrazového vyšetření odpovědět) případně zadanou i kódem SNOMED-CT a důvod objednávky (v podstatě odpovídá stručné epikríze, opět s možností zadat tutéž informaci pomocí kódu). Výhodou zadávání kódem by v budoucnu mohlo být provázání s již zadanými informacemi v NIS, Indikující lékař by tedy reálně tyto informace zadávat podruhé nemusel.

**Platba**

Tato část umožňuje upřesnění, pokud je část vyšetření hrazena jinak než většina (např. speciální rekonstrukce nehrazené pojištěním). I když je vyžadováno, aby byla tato část přítomna, není povinné ji vyplňovat, což znamená, že může být ponecháno prázdné, pokud to není možné.

Volný textový komentář k úhradě lze použít v případě potřeby upřesnit, kterou část péče hradí jiný plátce. To umožňuje jasnost a transparentnost, pokud jde o finanční odpovědnost a ujednání související s poskytovanými zdravotnickými službami.

**Termín vyšetření (návštěvy)**

Tato požadovaná sekce zahrnuje potvrzené informace z vyšetřujícího ZZ o objednávce, tj. na kdy je pacient objednán, kam má přijít, včetně volného textu komentáře (např. MR na 2. patře hlavní budovy). Využití těchto struktur předpokládá, že bude možné po přijetí žádanky vyšetřujícím ZZ tyto informace „doplnit“ neboli vytvořit aktualizovanou verzi žádanky tuto informaci obsahující.

**Objednávky plánované péče**

Odkazy na objednávky plánované péče navazující na tuto žádanku. Kromě ID by měl obsahovat i název této schůzky, ostatní informace by se měly automaticky doplnit z odkazované objednávky. Například “Konzultace na neurochirurgii”, přes ID pak zjistit, že bude v ÚVN 15.3.2040 v 16:15.

**Implantáty**

V této sekci je uveden seznam implantátů či pomůcek majících vliv na průběh vyšetření či jeho interpretaci.

**Přílohy**

Tato požadovaná sekce umožní přidat libovolný další zdroj informací (například ambulantní zprávy, propouštěcí zprávy – v digitální podobě nebo i jen scan, data poskytnutá pacientem atd. Opět není povinná, pouze otevíráme možnost libovolné přílohy).

## Content (en)

### Sections and content

The document is divided into a set of mandatory and optional sections. In case no data is available for a mandatory section, the justification can be expressed in `composition.section.emptyReason`.

### Document structure

The Imaging order holds the following sections in this order:

#### Imaging Order Header

General information on the order. Most of the information elements in this part of the order overlap with other clinical orders. The document header includes information on the patient, source organization, author, attester and custodian of the order.

**Clinical Encounter (Encounter)**

This profile allows for linking the order form to a specific clinical encounter, such as an outpatient visit during which the order was created.

#### Body of the Imaging Order

**Order Information**

This mandatory section includes the required order identifier ([A.2.1.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.identifier)) and the date and time of its creation ([A.2.1.2](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.dateTime)) — if the information section is established, it must contain these details. Optional items include the urgency of the order (from the perspective of Indicating Physician) expressed by an international code from the HL7 system ([Request Priority](https://hl7.org/fhir/valueset-request-priority.html)) ([A.2.1.4](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.urgency)), which can have values such as routine (normal priority), urgent (urgent case), asap (as soon as possible) and stat (status iminens / STATIM). Another optional item is the requested date and time of the examination ([A.2.1.3](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.requestedExecdateTime)), which does not refer to the actual booking date but opens the possibility, for example, to send an order form with a request for scheduling on the day when the patient has an outpatient clinical check-up.

Additional Requirements / Detailed Examination Specifications ([A.2.1.5](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderDetails.orderText)) is another optional field that can contain extra information for the order. This could include, for example, the Referring physician request for using a specific agreed-upon protocol or conducting the examination on a specific MRI machine.

The final optional item is information for the patient, such as fasting requirements, medication discontinuation, advice on claustrophobia, etc.

**Justification for Examination (Clinical question)**

This required section includes the indicative diagnosis ([A.2.2.1](StructureDefinition-ImageOrderInformationCz-definitions.md#key_ImageOrderInformationCz.orderReason.problem)), which is required by health insurance companies for service reimbursement. Additional items include the clinical question (an interrogative sentence that should end with a question mark and should be answerable based on the imaging examination) which can also be assigned a SNOMED CT code, and the reason for the order (essentially a brief summary, again with the option to encode the information). The advantage of using a code in the future could be the integration with existing information in the Indicating Physician's system within the NIS (Nursing Information System), thereby eliminating the need to re-enter this information.

**Payment (Coverage)**

This section allows for specification if part of the examination is covered differently than the majority of it (e.g. special reconstructions not covered by insurance). While this section is required to be present, it is not mandatory to fill it out, meaning it can be left blank if not applicable.

A free text comment on payment can be used when there is a need to specify which part of the care is covered by a different payer. This allows for clarity and transparency regarding the financial responsibilities and arrangements associated with the provided healthcare services.

**Examination Appointment (Visit)**

This mandatory section includes confirmed information from the examining healthcare facility about the appointment, such as when the patient is scheduled, where they need to go, and may include free text comments (e.g. MRI on the 2nd floor of the main building). The use of these structures assumes that it will be possible, after the order has been received by the examining healthcare facility, to "supplement" this information or create an updated version of the order form that includes this information.

**Care plans**

This section contains references to scheduled care plan orders that follow from this order form. Besides the ID, it should include the name of the appointment, with other details being automatically populated from the referenced order. For example, an entry may state "Consultation in Neurosurgery" and by using the ID, one can determine that it is scheduled at the Central Military Hospital on March 15, 2040, at 16:15. This facilitates efficient tracking and management of the patient’s care pathway.

**Medical Devices (Implants)**

This section contains a list of implants or devices that affect the course of the examination or its interpretation.

**Attachments**

This optional section allows for the inclusion of any additional sources of information, such as outpatient reports, discharge summaries (in digital form or even just a scan), data provided by the patient, etc. While this section is not mandatory, it provides the flexibility to attach various types of files or documents to supplement the order form with relevant information.

**Usages:**

* Use this Profile: [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* Examples for this Profile: [Composition/dbd426a9-d660-4f97-8656-1e39db4a57c9](Composition-dbd426a9-d660-4f97-8656-1e39db4a57c9.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-compositionImageOrder)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-compositionImageOrder.csv), [Excel](StructureDefinition-cz-compositionImageOrder.xlsx), [Schematron](StructureDefinition-cz-compositionImageOrder.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-compositionImageOrder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder",
  "version" : "0.1.0-ballot",
  "name" : "CZ_CompositionImageOrder",
  "title" : "Composition: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Imaging Order for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "Imaging order bundle is an electronic health record extract containing order for imaging observation from a subject of care, comprising at least the required elements of the imaging dataset.",
  "copyright" : "HL7 CZ",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Imaging Order Composition",
        "definition" : "Imaging Order Composition. \r\n\r\n A composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.",
        "constraint" : [
          {
            "key" : "text-or-section",
            "severity" : "error",
            "human" : "A Composition SHALL have either text, at least one section, or both.",
            "expression" : "text.exists() or section.exists()",
            "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-compositionImageOrder"
          }
        ]
      },
      {
        "id" : "Composition.meta.security",
        "path" : "Composition.meta.security",
        "mustSupport" : true
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:presentedForm",
        "path" : "Composition.extension",
        "sliceName" : "presentedForm",
        "short" : "Presented form",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.eu/fhir/StructureDefinition/presentedForm"]
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].contentType",
        "path" : "Composition.extension.value[x].contentType",
        "example" : [
          {
            "label" : "pdf",
            "valueCode" : "application/pdf"
          }
        ]
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].data",
        "path" : "Composition.extension.value[x].data",
        "short" : "B64 in-line data"
      },
      {
        "id" : "Composition.extension:presentedForm.value[x].url",
        "path" : "Composition.extension.value[x].url",
        "short" : "URL of the document"
      },
      {
        "id" : "Composition.extension:informationRecipient",
        "path" : "Composition.extension",
        "sliceName" : "informationRecipient",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/information-recipient"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:informationRecipient.value[x]",
        "path" : "Composition.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "Order identifier",
        "definition" : "Identifiers assigned to this Imaging Order by the performer or other systems. It shall be common to several report versions",
        "comment" : "Composition.identifier SHALL be equal to one of the OrderInformation.identifier, if at least one exists"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "Status of the Order"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://hl7.cz/fhir/img-order/ValueSet/cz-composition-type-vs"
        }
      },
      {
        "id" : "Composition.type.coding",
        "path" : "Composition.type.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Composition.type.coding:loinc",
        "path" : "Composition.type.coding",
        "sliceName" : "loinc",
        "min" : 1,
        "max" : "1",
        "patternCoding" : {
          "system" : "http://loinc.org",
          "code" : "18748-4"
        }
      },
      {
        "id" : "Composition.category",
        "path" : "Composition.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/document-classcodes"
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Context that defines the Imaging Order",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-encounter"]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "Date the order was created."
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Imaging order",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "short" : "Organization that manages the Imaging Order",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections composing the Imaging Order",
        "definition" : "The root of the sections that make up the Imaging Order composition.",
        "min" : 2
      },
      {
        "id" : "Composition.section:orderInformation",
        "path" : "Composition.section",
        "sliceName" : "orderInformation",
        "short" : "Order Information",
        "definition" : "This section holds information related to the order for the imaging study.",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Composition.section:orderInformation.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "55115-0",
              "display" : "Requested imaging studies information Document"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:orderInformation.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:clinicalQuestion",
        "path" : "Composition.section",
        "sliceName" : "clinicalQuestion",
        "short" : "Clinical question",
        "definition" : "This section holds information about the clinical question or questions that the imaging service is intended to answer.",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Composition.section:clinicalQuestion.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18785-6",
              "display" : "Radiology Reason for study (narrative)"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:clinicalQuestion.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-device-observer",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:clinicalQuestion.text",
        "path" : "Composition.section.text",
        "short" : "Clinical question text",
        "min" : 1
      },
      {
        "id" : "Composition.section:clinicalQuestion.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionClinicalQuestion"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:coverage",
        "path" : "Composition.section",
        "sliceName" : "coverage",
        "short" : "Coverage type",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:coverage.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "87520-3",
              "display" : "Coverage type"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:coverage.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-coverage"]
          }
        ]
      },
      {
        "id" : "Composition.section:appointment",
        "path" : "Composition.section",
        "sliceName" : "appointment",
        "short" : "Appointment",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:appointment.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "56446-8",
              "display" : "Appointment summary Document"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:appointment.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-appointment"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:carePlan",
        "path" : "Composition.section",
        "sliceName" : "carePlan",
        "short" : "Care Plan",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:carePlan.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "18776-5",
              "display" : "Plan of care note"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:carePlan.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:medicalDevices",
        "path" : "Composition.section",
        "sliceName" : "medicalDevices",
        "short" : "Medical Devices and implants",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:medicalDevices.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "97813-0",
              "display" : "Implant component"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:medicalDevices.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:supportingInformation",
        "path" : "Composition.section",
        "sliceName" : "supportingInformation",
        "short" : "Supporting information",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:supportingInformation.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "55752-0",
              "display" : "Clinical information"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:supportingInformation.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-potientMobility",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-medical-device",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
              "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:attachments",
        "path" : "Composition.section",
        "sliceName" : "attachments",
        "short" : "Library of attachments",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Composition.section:attachments.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "77599-9",
              "display" : "Additional documentation"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:attachments.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-attachment"]
          }
        ]
      }
    ]
  }
}

```
