# Care plan: Imaging Order (CZ) - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Care plan: Imaging Order (CZ)**

## Resource Profile: Care plan: Imaging Order (CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:CZ_CarePlanImage |

 
Care plan for Imaging Order for the scope of the Czech national interoperability project. 

**Usages:**

* Use this Profile: [Bundle: Imaging Order (CZ)](StructureDefinition-cz-bundleImageOrder.md)
* Refer to this Profile: [Composition: Imaging Order (CZ)](StructureDefinition-cz-compositionImageOrder.md) and [Service Request: Imaging Order (CZ)](StructureDefinition-cz-imagingOrderInformation.md)
* Examples for this Profile: [CarePlan/CarePlanExample](CarePlan-CarePlanExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/cz-carePlanImage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-carePlanImage.csv), [Excel](StructureDefinition-cz-carePlanImage.xlsx), [Schematron](StructureDefinition-cz-carePlanImage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-carePlanImage",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage",
  "version" : "0.1.0-ballot",
  "name" : "CZ_CarePlanImage",
  "title" : "Care plan: Imaging Order (CZ)",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Care plan for Imaging Order for the scope of the Czech national interoperability project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan",
        "path" : "CarePlan"
      }
    ]
  }
}

```
