# A.3.4 - Other Supporting Information - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.4 - Other Supporting Information**

## Logical Model: A.3.4 - Other Supporting Information 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogEnOtherSupportingInformationCz |

 
Other Supporting Information - Links to other supporting information related to this request form 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/OtherSupportingInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OtherSupportingInformationCz.csv), [Excel](StructureDefinition-OtherSupportingInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OtherSupportingInformationCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnOtherSupportingInformationCz",
  "title" : "A.3.4 - Other Supporting Information",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Other Supporting Information - Links to other supporting information related to this request form",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OtherSupportingInformationCz",
        "path" : "OtherSupportingInformationCz",
        "short" : "A.3.4 - Other Supporting Information",
        "definition" : "Other Supporting Information - Links to other supporting information related to this request form"
      },
      {
        "id" : "OtherSupportingInformationCz.identifier",
        "path" : "OtherSupportingInformationCz.identifier",
        "short" : "A.3.4.1 - Other supporting information identifier",
        "definition" : "Planned care order identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "OtherSupportingInformationCz.name",
        "path" : "OtherSupportingInformationCz.name",
        "short" : "A.3.4.2 - Name",
        "definition" : "Name of other supporting information for display in the list of appointments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
