# A.3.2 - Order Data Elements - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.2 - Order Data Elements**

## Logical Model: A.3.2 - Order Data Elements 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/OrderDataElementsCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogEnOrderDataElementsCz |

 
Order Data Elements - Order/examination data elements 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/OrderDataElementsCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-OrderDataElementsCz.csv), [Excel](StructureDefinition-OrderDataElementsCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "OrderDataElementsCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/OrderDataElementsCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnOrderDataElementsCz",
  "title" : "A.3.2 - Order Data Elements",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Order Data Elements - Order/examination data elements ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/OrderDataElementsCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "OrderDataElementsCz",
        "path" : "OrderDataElementsCz",
        "short" : "A.3.2 - Order Data Elements",
        "definition" : "Order Data Elements - Order/examination data elements "
      },
      {
        "id" : "OrderDataElementsCz.code",
        "path" : "OrderDataElementsCz.code",
        "short" : "A.3.2.1 - Examination code",
        "definition" : "Code representing the examination within the agreed code list, including its name.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OrderDataElementsCz.name",
        "path" : "OrderDataElementsCz.name",
        "short" : "A.3.2.2 - Name of the examination",
        "definition" : "Full name of the examination, if different from the coded information.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "OrderDataElementsCz.modality",
        "path" : "OrderDataElementsCz.modality",
        "short" : "A.3.2.3 - Modality",
        "definition" : "Required examination method (measurement principle).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OrderDataElementsCz.bodyPart",
        "path" : "OrderDataElementsCz.bodyPart",
        "short" : "A.3.2.4 - Body Part",
        "definition" : "Body part being examined",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OrderDataElementsCz.laterality",
        "path" : "OrderDataElementsCz.laterality",
        "short" : "A.3.2.5 - Laterality",
        "definition" : "Body side",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "OrderDataElementsCz.note",
        "path" : "OrderDataElementsCz.note",
        "short" : "A.3.2.6 - Note",
        "definition" : "Customer's note on the requested examination",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
