# A - Imaging Order - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Imaging Order**

## Logical Model: A - Imaging Order 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/ImagingOrderCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnImagingOrderCz |

 
Imaging Order 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/ImagingOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ImagingOrderCz.csv), [Excel](StructureDefinition-ImagingOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImagingOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImagingOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnImagingOrderCz",
  "title" : "A - Imaging Order",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Imaging Order",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImagingOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ImagingOrderCz",
        "path" : "ImagingOrderCz",
        "short" : "A - Imaging Order",
        "definition" : "Imaging Order"
      },
      {
        "id" : "ImagingOrderCz.header",
        "path" : "ImagingOrderCz.header",
        "short" : "A.1 - Imaging Order header data element",
        "definition" : "Imaging Order header data element",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/HeaderImagingOrder"
          }
        ]
      },
      {
        "id" : "ImagingOrderCz.body",
        "path" : "ImagingOrderCz.body",
        "short" : "A.2 a A.3 - Imaging Order body data element",
        "definition" : "Imaging Order body data element",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/BodyImageOrderCz"
          }
        ]
      },
      {
        "id" : "ImagingOrderCz.presentedForm",
        "path" : "ImagingOrderCz.presentedForm",
        "short" : "A.4 - Presented Form",
        "definition" : "Entire order as issued. Various formats could be provided,  pdf format is recommended.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/PresentedFormCz"
          }
        ]
      },
      {
        "id" : "ImagingOrderCz.attachment",
        "path" : "ImagingOrderCz.attachment",
        "short" : "A.5 - Additional Attachment",
        "definition" : "Additional media attachment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/AttachmentsCz"
          }
        ]
      }
    ]
  }
}

```
