# A.3.1 - Supporting Information - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.1 - Supporting Information**

## Logical Model: A.3.1 - Supporting Information 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogEnImageSupportingInformationCz |

 
Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/ImageSupportingInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ImageSupportingInformationCz.csv), [Excel](StructureDefinition-ImageSupportingInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImageSupportingInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnImageSupportingInformationCz",
  "title" : "A.3.1 - Supporting Information",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ImageSupportingInformationCz",
        "path" : "ImageSupportingInformationCz",
        "short" : "A.3.1 - Supporting Information",
        "definition" : "Supporting Information - Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results"
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData",
        "path" : "ImageSupportingInformationCz.biometricData",
        "short" : "A.3.1.1 - Bimetric Data",
        "definition" : "If the required clinical data are available, it is mandatory.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.weight",
        "path" : "ImageSupportingInformationCz.biometricData.weight",
        "short" : "A.3.1.1.1 - Weight",
        "definition" : "Subject weight",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.weight.valueQuantity",
        "path" : "ImageSupportingInformationCz.biometricData.weight.valueQuantity",
        "short" : "A.3.1.1.1.1 - Weight value",
        "definition" : "Data value including unit of measurement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.weight.code",
        "path" : "ImageSupportingInformationCz.biometricData.weight.code",
        "short" : "A.3.1.1.1.2 - Weight code",
        "definition" : "Observation code identifying the meaning of the weight data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.weight.dateTime",
        "path" : "ImageSupportingInformationCz.biometricData.weight.dateTime",
        "short" : "A.3.1.1.1.3 - Weight date and time",
        "definition" : "The date of weight discovery is stated if it is different from the date of order issuance.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.height",
        "path" : "ImageSupportingInformationCz.biometricData.height",
        "short" : "A.3.1.1.2 - Height",
        "definition" : "Subject height",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.height.valueQuantity",
        "path" : "ImageSupportingInformationCz.biometricData.height.valueQuantity",
        "short" : "A.3.1.1.2.1 - Height value",
        "definition" : "Data value including unit of measurement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.height.code",
        "path" : "ImageSupportingInformationCz.biometricData.height.code",
        "short" : "A.3.1.1.2.2 - Height code",
        "definition" : "Observation code identifying the meaning of the height data",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.biometricData.height.dateTime",
        "path" : "ImageSupportingInformationCz.biometricData.height.dateTime",
        "short" : "A.3.1.1.2.3 - Height date and time",
        "definition" : "The date of height discovery is stated if it is different from the date of order issuance.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherRelevantClinicalInformation",
        "path" : "ImageSupportingInformationCz.otherRelevantClinicalInformation",
        "short" : "A.3.1.2 - Other relevant clinical information",
        "definition" : "Other relevant clinical information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherRelevantClinicalInformation.code",
        "path" : "ImageSupportingInformationCz.otherRelevantClinicalInformation.code",
        "short" : "A.3.1.2.1 - Code of other information",
        "definition" : "Diagnoses and other clinical information that may affect the course or result of the examination or its interpretation (e.g. heart failure, claustrophobia, renal failure)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherRelevantClinicalInformation.text",
        "path" : "ImageSupportingInformationCz.otherRelevantClinicalInformation.text",
        "short" : "A.3.1.2.2 - Text of other information",
        "definition" : "Clinical information necessary for correct order execution or interpretation of results.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication",
        "path" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication",
        "short" : "A.3.1.3 -  Possible contraindications for examination or administration of contrast medium",
        "definition" : "Medication block containing information about medication that has an impact on the course or result of the examination or its interpretation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication",
        "path" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication",
        "short" : "A.3.1.3.1 - Medication",
        "definition" : "Medication block containing information about medication that has an impact on the course or result of the examination or its interpretation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.identifier",
        "path" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.identifier",
        "short" : "A.3.1.3.1.1 - Medication identifier",
        "definition" : "Identifier of medication",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.code",
        "path" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.code",
        "short" : "A.3.1.3.1.2 - Medication code",
        "definition" : "Code of medication",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "code"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.amount",
        "path" : "ImageSupportingInformationCz.possibleContraindicationsDueToMedication.medication.amount",
        "short" : "A.3.1.3.1.3 - Ratio",
        "definition" : "Amount of drug in package",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.implant",
        "path" : "ImageSupportingInformationCz.implant",
        "short" : "A.3.1.4 - Implant",
        "definition" : "List of implants or devices that affect the course of the examination or its interpretation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.implant.type",
        "path" : "ImageSupportingInformationCz.implant.type",
        "short" : "A.3.1.4.1 - Implant type",
        "definition" : "Type of implant",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.implant.identifier",
        "path" : "ImageSupportingInformationCz.implant.identifier",
        "short" : "A.3.1.4.2 - Implant identifier",
        "definition" : "Standardized identifier, e.g. UDI, according to EU Regulation 2017/745, ZP code according to the health insurance company catalog",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.implant.model",
        "path" : "ImageSupportingInformationCz.implant.model",
        "short" : "A.3.1.4.3 - Implant model",
        "definition" : "Specifies a specific model",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.implant.bodyPart",
        "path" : "ImageSupportingInformationCz.implant.bodyPart",
        "short" : "A.3.1.4.4 - Body part",
        "definition" : "Body part where it is implanted",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.urgentInformation",
        "path" : "ImageSupportingInformationCz.urgentInformation",
        "short" : "A.3.1.5 - Urgent information",
        "definition" : "Urgent information block in the same structure as in other types of documents (discharge report, patient summary)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.urgentInformation.allergyIntolerance",
        "path" : "ImageSupportingInformationCz.urgentInformation.allergyIntolerance",
        "short" : "A.3.1.5.1 - Allergy intolerance",
        "definition" : "Allergies and intolerances that may affect order fulfillment or interpretation of results",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.urgentInformation.warnings",
        "path" : "ImageSupportingInformationCz.urgentInformation.warnings",
        "short" : "A.3.1.5.2 - Warning",
        "definition" : "Warnings and notices that may affect order fulfillment or interpretation of results",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.limitationOfPatientMobility",
        "path" : "ImageSupportingInformationCz.limitationOfPatientMobility",
        "short" : "A.3.1.6 - Limitation of patient mobility",
        "definition" : "Describes the patient's mobility limitations",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherInformation",
        "path" : "ImageSupportingInformationCz.otherInformation",
        "short" : "A.3.1.7 - Other information",
        "definition" : "Other formalized observation communicated to the implementing workplace",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherInformation.dateTime",
        "path" : "ImageSupportingInformationCz.otherInformation.dateTime",
        "short" : "A.3.1.7.1 - Date and time of information",
        "definition" : "Date of information discovery, stated if different from the date of order",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherInformation.code",
        "path" : "ImageSupportingInformationCz.otherInformation.code",
        "short" : "A.3.1.7.2 - Code of information",
        "definition" : "Observation code identifying the meaning of the observation (week of gestation, etc.)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageSupportingInformationCz.otherInformation.value",
        "path" : "ImageSupportingInformationCz.otherInformation.value",
        "short" : "A.3.1.7.3 - Value of information",
        "definition" : "Observation value including unit of measurement.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
