# A.2.1 - Order information and A.2.2 - Order reason - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.1 - Order information and A.2.2 - Order reason**

## Logical Model: A.2.1 - Order information and A.2.2 - Order reason 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnImageOrderInformationCz |

 
Information about order and order reason 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/ImageOrderInformationCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ImageOrderInformationCz.csv), [Excel](StructureDefinition-ImageOrderInformationCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImageOrderInformationCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnImageOrderInformationCz",
  "title" : "A.2.1 - Order information and A.2.2 - Order reason",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Information about order and order reason",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ImageOrderInformationCz",
        "path" : "ImageOrderInformationCz",
        "short" : "A.2.1 - Order information and A.2.2 - Order reason",
        "definition" : "Information about order and order reason"
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails",
        "path" : "ImageOrderInformationCz.orderDetails",
        "short" : "A.2.1 - Order information",
        "definition" : "Order information could respond to multiple test orders ",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.identifier",
        "path" : "ImageOrderInformationCz.orderDetails.identifier",
        "short" : "A.2.1.1 - Order Id",
        "definition" : "An identifier of the imaging order.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.dateTime",
        "path" : "ImageOrderInformationCz.orderDetails.dateTime",
        "short" : "A.2.1.2 - Order date and time",
        "definition" : "Date and time of the order placement.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.requestedExecdateTime",
        "path" : "ImageOrderInformationCz.orderDetails.requestedExecdateTime",
        "short" : "A.2.1.3 - Date and time of requested execution",
        "definition" : "Date and time of requested execution",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.urgency",
        "path" : "ImageOrderInformationCz.orderDetails.urgency",
        "short" : "A.2.1.4 - Urgency of the order",
        "definition" : "Urgency of the order (routine, urgent, statim). \n- Preferred system(s): HL7:RequestPriority",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.orderText",
        "path" : "ImageOrderInformationCz.orderDetails.orderText",
        "short" : "A.2.1.5 - Order text",
        "definition" : "A textual description of the order or additional requirements, specific to each type of order, if they cannot be expressed formally.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderDetails.infoForPatient",
        "path" : "ImageOrderInformationCz.orderDetails.infoForPatient",
        "short" : "A.2.1.6 - Information for the patient",
        "definition" : "Patient instructions related to the order. E.g. fasting collection, etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason",
        "path" : "ImageOrderInformationCz.orderReason",
        "short" : "A.2.2 - Order reason",
        "definition" : "Reason of imaging order",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason.problem",
        "path" : "ImageOrderInformationCz.orderReason.problem",
        "short" : "A.2.2.1 - Problem / diagnosis / condition description",
        "definition" : "The reason for issuing an examination order expressed in structured text and/or code.\n- Preferred system(s): MKN-10\n- Preferred system(s): Orphacode",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason.questionCode",
        "path" : "ImageOrderInformationCz.orderReason.questionCode",
        "short" : "A.2.2.2 - Clinical question by code",
        "definition" : "Coded information from 2.2.3, if entered\n- Preferred system(s): SNOMED CT",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason.questionText",
        "path" : "ImageOrderInformationCz.orderReason.questionText",
        "short" : "A.2.2.3 - Clinical question by text",
        "definition" : "The clinical question to be answered by imaging. Example: Does the patient have a lung tumour ?",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason.reasonCode",
        "path" : "ImageOrderInformationCz.orderReason.reasonCode",
        "short" : "A.2.2.4 - Reason for ordering by code",
        "definition" : "Coded information from 2.2.5, if entered\n- Preferred system(s): SNOMED CT ReasonCodelist 243796009 (Situation with explicit context (situation)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageOrderInformationCz.orderReason.reasonText",
        "path" : "ImageOrderInformationCz.orderReason.reasonText",
        "short" : "A.2.2.5 - Reason for order by text",
        "definition" : "Reason for the examination order expressed in free text (e.g. 3 weeks of persistent cough)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
