# A.2.5 - Appointment - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.5 - Appointment**

## Logical Model: A.2.5 - Appointment 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/ImageAppointmentCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogEnImageAppointmentCz |

 
Appointment - Links to planned care order related to this request form 

**Usages:**

* Use this Logical Model: [A.2 and A.3 - Body Imaging Order](StructureDefinition-BodyImageOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/ImageAppointmentCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ImageAppointmentCz.csv), [Excel](StructureDefinition-ImageAppointmentCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ImageAppointmentCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageAppointmentCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnImageAppointmentCz",
  "title" : "A.2.5 - Appointment",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Appointment - Links to planned care order related to this request form",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageAppointmentCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "ImageAppointmentCz",
        "path" : "ImageAppointmentCz",
        "short" : "A.2.5 - Appointment",
        "definition" : "Appointment - Links to planned care order related to this request form"
      },
      {
        "id" : "ImageAppointmentCz.id",
        "path" : "ImageAppointmentCz.id",
        "short" : "A.2.5.1 - Appointment identifier",
        "definition" : "Appointment identifier",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.status",
        "path" : "ImageAppointmentCz.status",
        "short" : "A.2.5.2 - Appointment status",
        "definition" : "Appointment status (proposed, confirmed, cancelled)\nPreferred system(s): hl7:valueset-appointmentstatus",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.description",
        "path" : "ImageAppointmentCz.description",
        "short" : "A.2.5.3 - Description",
        "definition" : "Brief description of the date of the visit for display in the list of appointments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.dateTime",
        "path" : "ImageAppointmentCz.dateTime",
        "short" : "A.2.5.4 - Scheduled appointmnet date and time",
        "definition" : "Scheduled appointmnet date and time",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.examDuration",
        "path" : "ImageAppointmentCz.examDuration",
        "short" : "A.2.5.5 - Duration of appointment",
        "definition" : "Duration of appointment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.comment",
        "path" : "ImageAppointmentCz.comment",
        "short" : "A.2.5.6 - Comment",
        "definition" : "Additional comment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.patientInstruction",
        "path" : "ImageAppointmentCz.patientInstruction",
        "short" : "A.2.5.7 - Instructions for the patient",
        "definition" : "Patient instructions (e.g. arrive 15 minutes early, fasting, arrange for a ride, etc.)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "ImageAppointmentCz.place",
        "path" : "ImageAppointmentCz.place",
        "short" : "A.2.5.8 - Place",
        "definition" : "Name and address of the workplace where the appointment was arranged.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
