# A.1 - Imaging Order header data element - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Imaging Order header data element**

## Logical Model: A.1 - Imaging Order header data element 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/HeaderImagingOrder | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnHeaderImagingOrderCz |

 
Imaging Order - Imaging Order header data element - A.1 

**Usages:**

* Use this Logical Model: [A - Imaging Order](StructureDefinition-ImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/HeaderImagingOrder)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HeaderImagingOrder.csv), [Excel](StructureDefinition-HeaderImagingOrder.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HeaderImagingOrder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/HeaderImagingOrder",
  "version" : "0.1.0-ballot",
  "name" : "LogEnHeaderImagingOrderCz",
  "title" : "A.1 - Imaging Order header data element",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Imaging Order - Imaging Order header data element - A.1",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/HeaderImagingOrder",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HeaderImagingOrder",
        "path" : "HeaderImagingOrder",
        "short" : "A.1 - Imaging Order header data element",
        "definition" : "Imaging Order - Imaging Order header data element - A.1"
      },
      {
        "id" : "HeaderImagingOrder.subject",
        "path" : "HeaderImagingOrder.subject",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Identification of the patient/subject and Patient/subject related contact information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/SubjectCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.payer",
        "path" : "HeaderImagingOrder.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/PayerCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.coverage",
        "path" : "HeaderImagingOrder.coverage",
        "short" : "A.1.4 - Information about coverage - the default value will be the patient's insurance company",
        "definition" : "Coverage information - Information about method of coverage, payer identification data and additional information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageOrderCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.author",
        "path" : "HeaderImagingOrder.author",
        "short" : "A.1.5 - Author (who requested the order). Multiple authors could be provided.",
        "definition" : "Author (who requested the order). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.requestedPerformer",
        "path" : "HeaderImagingOrder.requestedPerformer",
        "short" : "A.1.6 - Requested Performer (processing person)",
        "definition" : "Person who is requested to process document.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/RequestedPerformerCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.additionalRecipient",
        "path" : "HeaderImagingOrder.additionalRecipient",
        "short" : "A.1.7 - Additional Recipient (additional recipients of the finding)",
        "definition" : "Additional recipients of the finding in addition to the author",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/AdditionalRecipientCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.documentMetadata",
        "path" : "HeaderImagingOrder.documentMetadata",
        "short" : "A.1.8 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/DocumentMetadataCz"
          }
        ]
      },
      {
        "id" : "HeaderImagingOrder.digitalSignature",
        "path" : "HeaderImagingOrder.digitalSignature",
        "short" : "A.1.9 - Digital signature",
        "definition" : "Digital signature",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/digitalSignatureCz"
          }
        ]
      }
    ]
  }
}

```
