# A.1.8 - Document metadata - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.8 - Document metadata**

## Logical Model: A.1.8 - Document metadata 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/DocumentMetadataCz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:LogEnDocumentMetadataOrderCz |

 
Document metadata 

**Usages:**

* Use this Logical Model: [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/DocumentMetadataCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentMetadataCz.csv), [Excel](StructureDefinition-DocumentMetadataCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentMetadataCz",
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/DocumentMetadataCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnDocumentMetadataOrderCz",
  "title" : "A.1.8 - Document metadata",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Document metadata",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/DocumentMetadataCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentMetadataCz",
        "path" : "DocumentMetadataCz",
        "short" : "A.1.8 - Document metadata",
        "definition" : "Document metadata"
      },
      {
        "id" : "DocumentMetadataCz.identifier",
        "path" : "DocumentMetadataCz.identifier",
        "short" : "A.1.8.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.category",
        "path" : "DocumentMetadataCz.category",
        "short" : "A.1.8.2 - Document category",
        "definition" : "Identifies the category of document at hand, e.g. Imaging order.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.status",
        "path" : "DocumentMetadataCz.status",
        "short" : "A.1.8.3 - Document status",
        "definition" : "The status of the Imaging order. E.g., preliminary, final.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.dateTime",
        "path" : "DocumentMetadataCz.dateTime",
        "short" : "A.1.8.4 - Order date and time",
        "definition" : "Date and time of the Imaging order creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.title",
        "path" : "DocumentMetadataCz.title",
        "short" : "A.1.8.5 - Document title",
        "definition" : "Document title of the Imaging order.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.custodian",
        "path" : "DocumentMetadataCz.custodian",
        "short" : "A.1.8.6 - Order custodian",
        "definition" : "Organisation that is in charge of maintaining the order [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.confidentiality",
        "path" : "DocumentMetadataCz.confidentiality",
        "short" : "A.1.8.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.language",
        "path" : "DocumentMetadataCz.language",
        "short" : "A.1.8.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "DocumentMetadataCz.version",
        "path" : "DocumentMetadataCz.version",
        "short" : "A.1.8.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
