# A.2 and A.3 - Body Imaging Order - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2 and A.3 - Body Imaging Order**

## Logical Model: A.2 and A.3 - Body Imaging Order 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/BodyImageOrderCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:LogEnBodyImageOrderCz |

 
Body Imaging Order 

**Usages:**

* Use this Logical Model: [A - Imaging Order](StructureDefinition-ImagingOrderCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/BodyImageOrderCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BodyImageOrderCz.csv), [Excel](StructureDefinition-BodyImageOrderCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BodyImageOrderCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/BodyImageOrderCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnBodyImageOrderCz",
  "title" : "A.2 and A.3 - Body Imaging Order",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Body Imaging Order",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/BodyImageOrderCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BodyImageOrderCz",
        "path" : "BodyImageOrderCz",
        "short" : "A.2 and A.3 - Body Imaging Order",
        "definition" : "Body Imaging Order"
      },
      {
        "id" : "BodyImageOrderCz.orderInformation",
        "path" : "BodyImageOrderCz.orderInformation",
        "short" : "A.2.1 - Order and A.2.2 order reason",
        "definition" : "A.2.1 - Order and A.2.2 order reason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.clinicalEvent",
        "path" : "BodyImageOrderCz.clinicalEvent",
        "short" : "A.2.3 - Clinical Event",
        "definition" : "Information about the clinical event to which the order relates",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/ClinicalEventCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.coverage",
        "path" : "BodyImageOrderCz.coverage",
        "short" : "A.2.4 - Coverage",
        "definition" : "Coverage information - Information about method of coverage, payer identification data and additional information",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageBodyCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.appointment",
        "path" : "BodyImageOrderCz.appointment",
        "short" : "A.2.5 - Appointment",
        "definition" : "Information about planned care order related to this request form",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageAppointmentCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.specimenInformation",
        "path" : "BodyImageOrderCz.specimenInformation",
        "short" : "A.2.6 - Specimen information",
        "definition" : "Information about specimen",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/SpecimenInformationCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.supportingInformation",
        "path" : "BodyImageOrderCz.supportingInformation",
        "short" : "A.3.1 - Supporting Information",
        "definition" : "Information and data communicated by the imaging methods department that has an impact on the execution of the order or the interpretation of the examination results",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.orderDataElements",
        "path" : "BodyImageOrderCz.orderDataElements",
        "short" : "A.3.2 - Order data elements",
        "definition" : "Information about Required examinations (service request)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/OrderDataElementsCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.plannedCareOrdersCz",
        "path" : "BodyImageOrderCz.plannedCareOrdersCz",
        "short" : "A.3.3 - Planned care orders",
        "definition" : "Links to others planned care orders related to this request form",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/PlannedCareOrdersCz"
          }
        ]
      },
      {
        "id" : "BodyImageOrderCz.otherSupportingInformationCz",
        "path" : "BodyImageOrderCz.otherSupportingInformationCz",
        "short" : "A.3.4 - Other supporting information",
        "definition" : "Links to other supporting information related to this request form",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz"
          }
        ]
      }
    ]
  }
}

```
