# A.1.5 - Author - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.5 - Author**

## Logical Model: A.1.5 - Author 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz | *Version*:0.1.0-ballot | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnAuthorOrderCz |

 
Author (by whom the Imaging order was/were authored). Multiple authors could be provided. 

**Usages:**

* Use this Logical Model: [A.1 - Imaging Order header data element](StructureDefinition-HeaderImagingOrder.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.img-order|current/StructureDefinition/AuthorCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AuthorCz.csv), [Excel](StructureDefinition-AuthorCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AuthorCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz",
  "version" : "0.1.0-ballot",
  "name" : "LogEnAuthorOrderCz",
  "title" : "A.1.5 - Author",
  "status" : "draft",
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Author (by whom the Imaging order was/were authored). Multiple authors could be provided.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/img-order/StructureDefinition/AuthorCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AuthorCz",
        "path" : "AuthorCz",
        "short" : "A.1.5 - Author",
        "definition" : "Author (by whom the Imaging order was/were authored). Multiple authors could be provided."
      },
      {
        "id" : "AuthorCz.identifier",
        "path" : "AuthorCz.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "AuthorCz.name",
        "path" : "AuthorCz.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "AuthorCz.address",
        "path" : "AuthorCz.address",
        "short" : "A.1.5.3 - Author's address",
        "definition" : "Contact details of the person placing the order (address and telecommunication details).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AuthorCz.organization",
        "path" : "AuthorCz.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
