# cz-organizationwithlogo-example - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **cz-organizationwithlogo-example**

## Example Organization: cz-organizationwithlogo-example

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Organization Logo**: [DocumentReference: status = current](Bundle-BundleKralikRTG.md#urn-uuid-0af43461-495e-4dfc-82ca-7f3140a60fe7)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/icp`/456789655, `https://ncez.mzcr.cz/fhir/sid/ico`/456789656

**type**: Fakultní nemocnice

**name**: Fakultní nemocnice Obláčkov

**telecom**: [+420257216007](tel:+420257216007), fax: +420257216007(Work)

**address**: Fiktivní 951/125, 100 00 Město(work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "5bdedd9b-27c5-4593-ae3a-968c5f25d253",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "extension" : [
    {
      "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo",
      "valueReference" : {
        "reference" : "urn:uuid:0af43461-495e-4dfc-82ca-7f3140a60fe7"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/icp",
      "value" : "456789655"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
      "value" : "456789656"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar",
          "code" : "101",
          "display" : "Fakultní nemocnice"
        }
      ]
    }
  ],
  "name" : "Fakultní nemocnice Obláčkov",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420257216007",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+420257216007",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Fiktivní 951/125, 100 00 Město",
      "line" : ["Fiktivní 951/125"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Fiktivní"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "951/125"
            }
          ]
        }
      ],
      "city" : "Město",
      "postalCode" : "10000",
      "country" : "CZ"
    }
  ]
}

```
