# Body weight of patient - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Body weight of patient**

## Example Observation: Body weight of patient

Profile: [Body Weight: Imaging Order (CZ)](StructureDefinition-cz-bodyweight.md)

**status**: Final

**category**: Vital Signs

**code**: Body weight

**subject**: [Mračena Mrakomorová Female, DoB: 1971-11-26 ( https://ncez.mzcr.cz/fhir/sid/rcis#2716126452 (use: official, ))](Patient-Mracena.md)

**effective**: 2020-06-01

**performer**: [Practitioner Testovací Jan](Practitioner-practitionerExample.md)

**value**: 65 kg(Details: UCUM codekg = 'kg')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "ExampleBodyWeight",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "29463-7"
      },
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "20042"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "27113001"
      }
    ]
  },
  "subject" : {
    "reference" : "Patient/Mracena"
  },
  "effectiveDateTime" : "2020-06-01",
  "performer" : [
    {
      "reference" : "Practitioner/practitionerExample"
    }
  ],
  "valueQuantity" : {
    "value" : 65,
    "unit" : "kg",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg"
  }
}

```
