# CZ Body Model to this guide Map - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Body Model to this guide Map**

## ConceptMap: CZ Body Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/img-order/ConceptMap/BodyImagingOrder2FHIR-cz | *Version*:0.1.0-ballot |
| Draft as of 2025-12-09 | *Computable Name*:BodyImagingOrder2FHIRcz |

 
CZ Imaging Order Body Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "BodyImagingOrder2FHIR-cz",
  "url" : "https://hl7.cz/fhir/img-order/ConceptMap/BodyImagingOrder2FHIR-cz",
  "version" : "0.1.0-ballot",
  "name" : "BodyImagingOrder2FHIRcz",
  "title" : "CZ Body Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-09T09:27:08+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Imaging Order Body Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation",
      "element" : [
        {
          "code" : "Body.OrderInformation",
          "display" : "A.2.1 and A.2.2 - Information about order",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation",
              "equivalence" : "relatedto",
              "comment" : "#Composition.OrderInformation.entry.ofType(CZ_ImagingOrderInformation)"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderDetail",
          "display" : "A.2.1 - Order detail",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.identifier",
          "display" : "A.2.1.1 - Identifier of order detail",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.dateTime",
          "display" : "A.2.1.2 - Date and time of the order placement",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.authoredOn",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.requestedExecdateTime",
          "display" : "A.2.1.3 - Date and time of requested execution",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.occurrenceDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.urgency",
          "display" : "A.2.1.4 - Urgency of the order",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.priority",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderText",
          "display" : "A.2.1.5 - Order text",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.note",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderText",
          "display" : "A.2.1.6 - Information for the patient",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.patientInstruction",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderReason",
          "display" : "A.2.2 - Order reason",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.reasonCode",
              "equivalence" : "equivalent",
              "comment" : "#CZ_ImagingOrderInformation.reasonReference.ofType(CZ_ConditionImage)"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderReason.problem",
          "display" : "A.2.2.1 -  Problem / diagnosis / condition description",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.reasonCode.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderDetail.reasonCode",
          "display" : "A.2.2.4 - Reason for ordering by code",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.reasonCode.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderDetail.reasonText",
          "display" : "A.2.2.6 - Reason for order by text",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.reasonCode.text",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageOrderInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage",
      "element" : [
        {
          "code" : "OrderInformation.orderDetail.questionCode",
          "display" : "A.2.2.2 - Clinical question in code form",
          "target" : [
            {
              "code" : "Composition.section:ClinicalQuestion.entry.ofType(CZ_ConditionClinicalQuestion).code",
              "display" : "In code form",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderInformation.orderDetail.questionText",
          "display" : "A.2.2.3 - A clinical question in text form",
          "target" : [
            {
              "code" : "Composition.section:ClinicalQuestion.text",
              "display" : "In text form",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ClinicalEventCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-encounter",
      "element" : [
        {
          "code" : "Body.ClinicalEvent",
          "display" : "A.2.3 - Information about clinical event",
          "target" : [
            {
              "code" : "Composition.encounter",
              "equivalence" : "relatedto",
              "comment" : "Composition.encounter.ofType(CZ_Encounter)"
            }
          ]
        },
        {
          "code" : "ClinicalEvent.identifier",
          "display" : "A.2.3.1 - Identifier of clinical event",
          "target" : [
            {
              "code" : "CZ_Encounter.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ClinicalEvent.type",
          "display" : "A.2.3.2 - Type of clinical event",
          "target" : [
            {
              "code" : "Composition.type",
              "display" : "FHIR Document Type Codes (LOINC) or Typ_KU (DASTA)",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "ClinicalEvent.otherInformation",
          "display" : "A.2.3.3 - Other information about clinical event",
          "target" : [
            {
              "code" : "CZ_Encounter.type.text",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/CoverageBodyCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
      "element" : [
        {
          "code" : "Body.coverage",
          "display" : "A.2.4 - Information about additional coverage",
          "target" : [
            {
              "code" : "Composition.section:Coverage",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:Coverage.entry.ofType(CZ_Coverage)"
            }
          ]
        },
        {
          "code" : "Body.coverage.method",
          "display" : "A.2.4.1 - Coverage method",
          "target" : [
            {
              "code" : "CZ_Coverage.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Body.coverage.informationPayor",
          "display" : "A.2.4.3 - Coverage comment",
          "target" : [
            {
              "code" : "CZ_Coverage.comment",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Body.coverage.comment"
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageAppointmentCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-appointment",
      "element" : [
        {
          "code" : "Body.Appointment",
          "display" : "A.2.5 - Information about appointment",
          "target" : [
            {
              "code" : "Composition.section:Appointment",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:Appointment.entry.ofType(CZ_Appointment)"
            }
          ]
        },
        {
          "code" : "Appointment.identifier",
          "display" : "A.2.5.1 - Identifier of appointment",
          "target" : [
            {
              "code" : "CZ_Appointment.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.status",
          "display" : "A.2.5.2 - Status of appointment",
          "target" : [
            {
              "code" : "CZ_Appointment.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.description",
          "display" : "A.2.5.3 - Description of appointment",
          "target" : [
            {
              "code" : "CZ_Appointment.description",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.dateTime",
          "display" : "A.2.5.4 - Date Time",
          "target" : [
            {
              "code" : "CZ_Appointment.created",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.examDuration",
          "display" : "A.2.5.5 - Duration of appointment",
          "target" : [
            {
              "code" : "CZ_Appointment.minutesDuration",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.comment",
          "display" : "A.2.5.6 - Comment about appointment",
          "target" : [
            {
              "code" : "CZ_Appointment.comment",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.patientInstruction",
          "display" : "A.2.5.7 - Instructions for the patient",
          "target" : [
            {
              "code" : "CZ_Appointment.patientInstruction",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Appointment.address",
          "display" : "A.2.5.7 - Address of the workplace",
          "target" : [
            {
              "code" : "CZ_Appointment.Location.address",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/SpecimenInformationCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-specimen",
      "element" : [
        {
          "code" : "Body.SpecimenInformation",
          "display" : "A.2.6 - Speciment information",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.specimen.ofType(CZ_Specimen)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.identifier",
          "display" : "A.2.6.1 - Identifier of specimen",
          "target" : [
            {
              "code" : "CZ_Specimen.identifier",
              "display" : "Identifier of specimen",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.species",
          "display" : "A.2.6.2 - Species of animal patient",
          "target" : [
            {
              "code" : "CZ_Specimen.subject.species",
              "display" : "Species of animal patient",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.material",
          "display" : "A.2.6.3 - Type of material",
          "target" : [
            {
              "code" : "CZ_Specimen.type",
              "display" : "Type of material",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collectionDate",
          "display" : "A.2.6.4 - Date and time of collection",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.collectionDate",
              "display" : "Date and time of collection",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.transportDate",
          "display" : "A.2.6.5 - Date and time of transport",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.receivedTime",
              "display" : "Date and time of commencement of transport of the sample to the laboratory",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.type",
          "display" : "A.2.6.6 - Sample type",
          "target" : [
            {
              "code" : "CZ_Specimen.type",
              "display" : "Entities collected for examination.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.anatomicLocation",
          "display" : "A.2.6.7 - Anatomic location",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.bodySite",
              "display" : "Anatomic location (body location, laterality) where the material is collected",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.morphology",
          "display" : "A.2.6.8 - Morphology",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.extension:bodySite:bodyStructure.morphology",
              "display" : "Morphological abnormalities of the anatomical location where the material is taken, for example wound, ulcer.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.instrument",
          "display" : "A.2.6.9 - Instrument",
          "target" : [
            {
              "code" : "CZ_Specimen.subject",
              "display" : "Device, instrument, physical object (drain, electrode, catheter, etc.).",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.procedure",
          "display" : "A.2.6.10 - Collection procedure",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.method",
              "display" : "Sampling procedure - for cases where it is relevant to the results.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.sourceDevice",
          "display" : "A.2.6.11 - Source Device",
          "target" : [
            {
              "code" : "CZ_Specimen.subject.type",
              "display" : "If the material is not collected directly from the patient but comes from a patient-related object, e.g. a catheter",
              "equivalence" : "equivalent",
              "comment" : "Device or Location"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.samplingPoint",
          "display" : "A.2.6.12 - Sampling point",
          "target" : [
            {
              "code" : "CZ_Specimen.subject.type",
              "display" : "The area where the material was collected; refers to the environment, not the patient.",
              "equivalence" : "equivalent",
              "comment" : "Location"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.Note",
          "display" : "A.2.6.13 - Note",
          "target" : [
            {
              "code" : "CZ_Specimen.note",
              "display" : "Note on the material in free text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.container",
          "display" : "A.2.6.14 - Container",
          "target" : [
            {
              "code" : "CZ_Specimen.container",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.container.type",
          "display" : "A.2.6.14.1 - Type",
          "target" : [
            {
              "code" : "CZ_Specimen.container.type",
              "display" : "Type of sampling container - tube, sampling bag, etc. including chemical additives.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.container.count",
          "display" : "A.2.6.14.2 - Specimen quantity",
          "target" : [
            {
              "code" : "CZ_Specimen.container.specimenQuantity",
              "display" : "Specimen quantity within container.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.container.deviceId",
          "display" : "A.2.6.14.3 - Device id",
          "target" : [
            {
              "code" : "CZ_Specimen.container.extension:Device:identifier",
              "display" : "Unique machine-readable container identifier.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.container.label",
          "display" : "A.2.6.14.4 - Label",
          "target" : [
            {
              "code" : "CZ_Specimen.collector.description",
              "display" : "Human readable container identifier.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.additionalData",
          "display" : "A.2.6.15 - Additional formalised sample data",
          "target" : [
            {
              "code" : "CZ_Specimen.collection",
              "display" : "Additional formalised sample data",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.additionalData.date",
          "display" : "A.2.6.15.1 - Date",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.collectedDateTime",
              "display" : "Date of discovery of the data, to be indicated if different from the date of the order.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.additionalData.value",
          "display" : "A.2.6.15.3 - Data value",
          "target" : [
            {
              "code" : "CZ_Specimen.collection.collectedPeriod",
              "display" : "Data value including unit of measurement.",
              "equivalence" : "equivalent",
              "comment" : "If #SpecimenInformation.additionalData.code = 08017 or 09056 (NCLPPOL - Čas odběru v minutách nebo sekundách)"
            },
            {
              "code" : "CZ_Specimen.collection.quantity",
              "display" : "Data value including unit of measurement.",
              "equivalence" : "equivalent",
              "comment" : "If #SpecimenInformation.additionalData.code = 03142 (NCLPPOL - Objem)"
            },
            {
              "code" : "CZ_Specimen.condition",
              "display" : "Data value including unit of measurement.",
              "equivalence" : "equivalent",
              "comment" : "If #SpecimenInformation.additionalData.code = 20293 (NCLPPOL - Stav materiálu)"
            },
            {
              "code" : "CZ_Specimen.note",
              "display" : "Data value including unit of measurement.",
              "equivalence" : "equivalent",
              "comment" : "If #SpecimenInformation.additionalData.code = 20206 (NCLPPOL - Poznámky-specifikace-jiné)"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collector",
          "display" : "A.2.6.16 - Collector",
          "target" : [
            {
              "code" : "CZ_Specimen.collector",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collector.identifier",
          "display" : "A.2.6.16.1 - Identifier of the sample collector",
          "target" : [
            {
              "code" : "CZ_Specimen.collector.identifier",
              "display" : "Identifier of the sample collector – this refers either to an internal identifier assigned by the healthcare provider or (preferably) a national ID of the healthcare professional, such as a license or registration number. If the sample is not collected by a healthcare professional but, for example, by the patient themselves, an appropriate personal identifier should be used instead.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collector.name",
          "display" : "A.2.6.16.2 - Name of the sample collector",
          "target" : [
            {
              "code" : "CZ_Specimen.collector.name",
              "display" : "Name of the sample collector",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collector.contact",
          "display" : "A.2.6.16.3 - Contact information of the sample collector",
          "target" : [
            {
              "code" : "CZ_Specimen.collector.address",
              "display" : "Contact information of the sample collector (address and telecommunication data).",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SpecimenInformation.collector",
          "display" : "A.2.6.16.4 - Organization of the sample collector",
          "target" : [
            {
              "code" : "CZ_Specimen.collector.organization",
              "display" : "Organization of the sample collector (healthcare provider).",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
      "element" : [
        {
          "code" : "Body.SupportingInformation.biometricData",
          "display" : "A.3.1.1 - Biometric data",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_ObservationImage)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.biometricData",
          "display" : "A.3.1.1 - Biometric data",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_ObservationImage)",
              "equivalence" : "relatedto"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyweight",
      "element" : [
        {
          "code" : "Body.SupportingInformation.weight",
          "display" : "A.3.1.1.2 - Weight",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_BodyWeight)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.weight",
          "display" : "A.3.1.1.2 - Weight",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_BodyWeight)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SupportingInformation.weight.valueQuantity",
          "display" : "A.3.1.1.2.1 - Value Quantity",
          "target" : [
            {
              "code" : "CZ_BodyWeight.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.weight.code",
          "display" : "A.3.1.1.2.2 - Code",
          "target" : [
            {
              "code" : "CZ_BodyWeight.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.weight.dateTime",
          "display" : "A.3.1.1.2.3 - DateTime",
          "target" : [
            {
              "code" : "CZ_BodyWeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-bodyheight",
      "element" : [
        {
          "code" : "Body.SupportingInformation.height",
          "display" : "A.3.1.1.2 - Height",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_BodyHeight)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.height",
          "display" : "A.3.1.1.2 - Height",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_BodyHeight)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SupportingInformation.height.valueQuantity",
          "display" : "A.3.1.1.2.1 - Value Quantity",
          "target" : [
            {
              "code" : "CZ_BodyHeight.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.height.code",
          "display" : "A.3.1.1.2.2 - Code",
          "target" : [
            {
              "code" : "CZ_BodyHeight.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.height.dateTime",
          "display" : "A.3.1.1.2.3 - DateTime",
          "target" : [
            {
              "code" : "CZ_BodyHeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-conditionImage",
      "element" : [
        {
          "code" : "Body.SupportingInformation.otherRelevantClinicalInformation",
          "display" : "A.3.1.2 - Other Relevant Clinical Information",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(Condition)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.otherRelevantClinicalInformation",
          "display" : "A.3.1.2 - Other Relevant Clinical Information",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(Condition)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SupportingInformation.otherRelevantClinicalInformation.code",
          "display" : "A.3.1.2.1 - Code",
          "target" : [
            {
              "code" : "Condition.code.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.otherRelevantClinicalInformation.text",
          "display" : "A.3.1.2.2 - Text",
          "target" : [
            {
              "code" : "Condition.code.text",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
      "element" : [
        {
          "code" : "Body.SupportingInformation.possibleContraindicationsDueToMedication.Medication",
          "display" : "A.3.1.3.1 - Medication",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_MedicationStatement)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.possibleContraindicationsDueToMedication.Medication",
          "display" : "A.3.1.3.1 - Medication",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_MedicationStatement)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Medication.identifier",
          "display" : "A.3.1.3.1.1 - Identifier of medication",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.code",
          "display" : "A.3.1.3.1.2 - Code of Medication",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Medication.amount",
          "display" : "A.3.1.3.1.3 - Amount of Medication",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.amount",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-deviceUseStatement",
      "element" : [
        {
          "code" : "Body.SupportingInformation.implant",
          "display" : "A.3.1.4 - Implant",
          "target" : [
            {
              "code" : "Composition.section:MedicalDevices",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:MedicalDevices.entry.ofType(CZ_DeviceUseStatement)"
            }
          ]
        },
        {
          "code" : "SupportingInformation.implant.type",
          "display" : "A.3.1.4.1 - Type",
          "target" : [
            {
              "code" : "CZ_DeviceUseStatement.device.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.implant.identifier",
          "display" : "A.3.1.4.2 - Identifier",
          "target" : [
            {
              "code" : "CZ_DeviceUseStatement.device.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.implant.model",
          "display" : "A.3.1.4.3 - Model",
          "target" : [
            {
              "code" : "CZ_DeviceUseStatement.device.modelNumber",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.implant.bodyPart",
          "display" : "A.3.1.4.4 - Body Part",
          "target" : [
            {
              "code" : "CZ_DeviceUseStatement.bodySite",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
      "element" : [
        {
          "code" : "Body.SupportingInformation.allergyIntolerance",
          "display" : "A.3.1.5.1 - Allergy intolerance",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_AllergyIntolerance)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.allergyIntolerance",
          "display" : "A.3.1.5.1 - Allergy intolerance",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_AllergyIntolerance)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.identifier",
          "display" : "A.3.1.5.1.1 - Identifier of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.identifier",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.clinicalStatus",
          "display" : "A.3.1.5.1.2 - Clinical status of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.clinicalStatus",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.type",
          "display" : "A.3.1.5.1.3 - Type of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.category",
          "display" : "A.3.1.5.1.4 - Category of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.category",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.code",
          "display" : "A.3.1.5.1.5 - Code of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "AllergyIntolerance.note",
          "display" : "A.3.1.5.1.6 - Note of allergyIntolerance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.note",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-flag",
      "element" : [
        {
          "code" : "Body.SupportingInformation.warnings",
          "display" : "A.3.1.5.2 - Warning",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_Flag)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.warnings",
          "display" : "A.3.1.5.2 - Warning",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_Flag)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.warnings.text",
          "display" : "A.3.1.5.2.1 - Text of warning",
          "target" : [
            {
              "code" : "Flag.text",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-potientMobility",
      "element" : [
        {
          "code" : "Body.SupportingInformation.limitationOfPatientMobility",
          "display" : "A.3.1.6 - Limitation of patient mobility",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_PatientMobility)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.limitationOfPatientMobility",
          "display" : "A.3.1.6 - Limitation of patient mobility",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_PatientMobility)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SupportingInformation.imitationOfPatientMobility.dateTime",
          "display" : "A.3.1.6.1 - Date and time of information",
          "target" : [
            {
              "code" : "CZ_PatientMobility.valueDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.imitationOfPatientMobility.code",
          "display" : "A.3.1.6.1 - Code of information",
          "target" : [
            {
              "code" : "CZ_PatientMobility.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.imitationOfPatientMobility.value",
          "display" : "A.3.1.6.2 - Value of information",
          "target" : [
            {
              "code" : "CZ_PatientMobility.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/ImageSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
      "element" : [
        {
          "code" : "Body.SupportingInformation.otherInformation",
          "display" : "A.3.1.7 - Other information",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_ObservationImage)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.SupportingInformation.otherInformation",
          "display" : "A.3.1.7 - Other information",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_ObservationImage)",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "SupportingInformation.otherInformation.dateTime",
          "display" : "A.3.1.7.1 - Date and time of information",
          "target" : [
            {
              "code" : "CZ_ObservationImage.valueDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.otherInformation.code",
          "display" : "A.3.1.7.2 - Code of information",
          "target" : [
            {
              "code" : "CZ_ObservationImage.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "SupportingInformation.otherInformation.value",
          "display" : "A.3.1.7.3 - Value of information",
          "target" : [
            {
              "code" : "CZ_ObservationImage.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/OrderDataElementsCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-imagingOrderInformation",
      "element" : [
        {
          "code" : "Body.OrderDataElements",
          "display" : "A.3.2.1 - Order/examination data elements.",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:OrderInformation.entry.ofType(CZ_ImagingOrderInformation)"
            }
          ]
        },
        {
          "code" : "OrderDataElements.code",
          "display" : "A.3.2.1.1 - Examination code",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderDataElements.name",
          "display" : "A.3.2.1.2 Name of the examination",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.text",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderDataElements.modality",
          "display" : "A.3.2.1.3 - Modality",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.orderDetail.modality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderDataElements.bodyPart",
          "display" : "A.3.2.1.4 - Body Part",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.extension:bodySite.location",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderDataElements.laterality",
          "display" : "A.3.2.1.5 - Laterality",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.extension:bodySite.extension:laterality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OrderDataElements.note",
          "display" : "A.3.2.1.6 - Examination note",
          "target" : [
            {
              "code" : "CZ_ImagingOrderInformation.note",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-carePlanImage",
      "element" : [
        {
          "code" : "Body.PlannedCareOrdersCz",
          "display" : "A.3.3 - Order/examination data elements.",
          "target" : [
            {
              "code" : "Composition.section:CarePlan",
              "equivalence" : "relatedto",
              "comment" : "Composition.section:CarePlan.entry.ofType(CZ_CarePlanImage)"
            }
          ]
        },
        {
          "code" : "PlannedCareOrdersCz.identifier",
          "display" : "A.3.3.1 - Identifier",
          "target" : [
            {
              "code" : "CZ_CarePlanImage.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PlannedCareOrdersCz.name",
          "display" : "A.3.3.2 Title of the observation",
          "target" : [
            {
              "code" : "CZ_CarePlanImage.title",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/img-order/StructureDefinition/OtherSupportingInformationCz",
      "target" : "https://hl7.cz/fhir/img-order/StructureDefinition/cz-observationImage",
      "element" : [
        {
          "code" : "Body.OtherSupportingInformationCz",
          "display" : "A.3.4 - Order/examination data elements.",
          "target" : [
            {
              "code" : "Composition.section:OrderInformation.supportingInfo.ofType(CZ_ObservationImage)\"",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "Body.OtherSupportingInformationCz",
          "display" : "A.3.4 - Order/examination data elements.",
          "target" : [
            {
              "code" : "Composition.section:SupportingInformation.ofType(CZ_ObservationImage)\"",
              "equivalence" : "relatedto"
            }
          ]
        },
        {
          "code" : "OtherSupportingInformationCz.identifier",
          "display" : "A.3.4.1 - Identifier",
          "target" : [
            {
              "code" : "CZ_ObservationImage.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "OtherSupportingInformationCz.name",
          "display" : "A.3.4.2 Title of the observation",
          "target" : [
            {
              "code" : "CZ_ObservationImage.title",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
