# AppointmentExample - HL7 Czech Imaging Order IG v0.1.0-ballot

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AppointmentExample**

## Example Appointment: AppointmentExample

Profile: [Appointment: Imaging Order (CZ)](StructureDefinition-cz-appointment.md)

**status**: Booked

**description**: Pravidelná kontrola

**start**: 2025-06-01 07:00:00+0200

**end**: 2025-06-01 07:30:00+0200

**minutesDuration**: 30

**created**: 2025-05-27

**patientInstruction**: Nalačno

### Participants

| | | | |
| :--- | :--- | :--- | :--- |
| - | **Actor** | **Required** | **Status** |
| * | [Ordinace - Jankovcova 2](Location-LocationExample.md) | Required | Accepted |



## Resource Content

```json
{
  "resourceType" : "Appointment",
  "id" : "AppointmentExample",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/img-order/StructureDefinition/cz-appointment"
    ]
  },
  "status" : "booked",
  "description" : "Pravidelná kontrola",
  "start" : "2025-06-01T07:00:00+02:00",
  "end" : "2025-06-01T07:30:00+02:00",
  "minutesDuration" : 30,
  "created" : "2025-05-27",
  "patientInstruction" : "Nalačno",
  "participant" : [
    {
      "actor" : {
        "reference" : "Location/LocationExample",
        "display" : "Ordinace - Jankovcova 2"
      },
      "required" : "required",
      "status" : "accepted"
    }
  ]
}

```
