# Obligations - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* **Obligations**

## Obligations

> **Informativní pro tuto verzi průvodce**Do této verze příručky byly přidány závazná pravidla pouze jako informativní materiál ke shromažďování zpětné vazby o jejich používání.

### Přehled

Závazná pravidla (Obligations) jsou prostředkem, kterým se v HL7 FHIR specifikuje schopnosti, které definovaní aktéři MOHOU (MAY), MĚLI BY (SHOULD) nebo MUSÍ (SHALL) mít implementovány specifikovanými profily.

Definujeme tři základní úrovně plnění standardu:

* L1 – nestrukturovaný dokument – předáváno jako nezbytná metadata dokumentu a lidsky čitelný dokument v PDF formátu
* L2 – strukturovaný dokument rozdělený do identifikovatelných sekcí (vstupní vyšetření, anamnéza, rizikové faktory, medikace, doporučení, …), obsah je stále veden pouze v textové neformalizované formě
* L3 – Dokument je strukturovaný do identifikovatelných sekcí (stejných jako v L2), některé informace lze vést ve formalizované podobě, vybrané informace budou povinně vedeny ve formalizované a kódované formě

Tato stránka také popisuje aktéry, kteří byli definováni pro specifikaci závazných pravidel.

### Aktéři

Byli specifikováni aktéři ve těchto rolích:

| | |
| :--- | :--- |
| [Tvůrce úrovně L1](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-actor-L1.html) | Jedná se o aktéra úrovně L1, který vytváří zprávu. Tuto zprávu lze odeslat konzumentovi nebo do úložiště pro ukládání a sdílení zpráv. |
| [Konzument úrovně L1](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-consumer-L1.html) | Tento aktér představuje systém úrovně L1, který přijatou nebo načtenou zprávu používá. |
|   |   |
| [Tvůrce úrovně L2](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-creator-L2.html) | Jedná se o aktéra úrovně L2, který vytváří zprávu. Tuto zprávu lze odeslat konzumentovi nebo do úložiště pro ukládání a sdílení zpráv. |
| [Konzument úrovně L2](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-consumer-L2.html) | Tento aktér představuje systém úrovně L2, který přijatou nebo načtenou zprávu používá. |
|   |   |
| [Tvůrce úrovně L3](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-creator-L3.html) | Jedná se o aktéra úrovně L3, který vytváří zprávu. Tuto zprávu lze odeslat konzumentovi nebo do úložiště pro ukládání a sdílení zpráv. |
| [Konzument úrovně L3](https://build.fhir.org/ig/HL7-cz/cz-core/ActorDefinition/actor-consumer-L3.html) | Tento aktér představuje systém úrovně L3, který přijatou nebo načtenou zprávu používá. |


### Seznam závazných pravidel

1. Pravidla pro profil alergie a intolerance ([CZ_AllergyIntoleranceObligationsHdr](StructureDefinition-cz-allergyintolerance-obl-hdr.md))
1. Pravidla pro profil přílohy ([CZ_AttachmentsObligationsHdr](StructureDefinition-cz-attachment-obl-hdr.md))
1. Pravidla pro profil kompozice ([CZ_CompositionObligationsHdr](StructureDefinition-cz-composition-obl-hdr.md))
1. Pravidla pro profil souhlas ([CZ_ConsentObligationsHdr](StructureDefinition-cz-consent-obl-hdr.md))
1. Pravidla pro profil dávky v rámci nemocničního pobytu ([CZ_DosageHospitalStayObligationsHdr](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md))
1. Pravidla pro profil dávky v rámci soupisu medikace ([CZ_DosageMedicationSummaryObligationsHdr](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md))
1. Pravidla pro profil klinické události ([CZ_EncounterObligationsHdr](StructureDefinition-cz-encounter-obl-hdr.md))
1. Pravidla pro profil příznak ([CZ_FlagObligationsHdr](StructureDefinition-cz-flag-obl-hdr.md))
1. Pravidla pro profil očkování ([CZ_ImmunizationObligationsHdr](StructureDefinition-cz-immunization-obl-hdr.md))
1. Pravidla pro profil doporučená očkování ([CZ_ImmunizationRecommendationObligationsHdr](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md))
1. Pravidla pro profil medikace v rámci nemocničního pobytu ([CZ_MedicationHospitalStayObligationsHdr](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md))
1. Pravidla pro profil medikace v rámci soupisu medikace ([CZ_MedicationMedicationSummaryObligationsHdr](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md))
1. Pravidla pro profil administrace medikace([CZ_MedicationAdministrationObligationsHdr](StructureDefinition-cz-medicationadministration-obl-hdr.md))
1. Pravidla pro profil výdej léku v rámci nemocničního pobytu ([CZ_MedicationDispenseHospitalStayObligationsHdr](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md))
1. Pravidla pro profil výdej léků v soupisu medikace ([CZ_MedicationDispenseMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md))
1. Pravidla pro profil podání léků v rámci nemocničního pobytu ([CZ_MedicationRequestHospitalStayObligationsHdr](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md))
1. Pravidla pro profil podání léků v soupisu medikace ([CZ_MedicationRequestMedicationSummaryObligationsHdr](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md))
1. Pravidla pro profil užívání léků ([CZ_MedicationStatementObligationsHdr](StructureDefinition-cz-medicationstatement-obl-hdr.md))
1. Pravidla pro profil nález antropometrických údajů ([CZ_ObservationAnthropometricDataHdrObligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md))
1. Pravidla pro profil nález infekčního kontaktu ([CZ_ObservationInfectiousContactHdrObligations](StructureDefinition-cz-observation-ic-obl-hdr.md))
1. Pravidla pro profil organizace([CZ_OrganizationObligationsHdr](StructureDefinition-cz-organization-obl-hdr.md))
1. Pravidla pro profil pacient ([CZ_PatientObligationsHdr](StructureDefinition-cz-patient-obl-hdr.md))
1. Pravidla pro profil procedura ([CZ_ProcedureObligationsHdr](StructureDefinition-cz-procedure-obl-hdr.md))

