# hl7.fhir.cz.hdr#0.1.0: HL7 Czech Hospital Discharge Report Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [MedicationSummary Relationships](MedicationSummary-map.md)
* [Scope and content](scope-and-content.md)
* [Implementační poznámky](implementation-notes-cs.md)
* [Logical models](logical-models.md)
* [FunctionalStatus Relationships](FunctionalStatus-map.md)
* [Background](background-cs.md)
* [Oblasti a obsah](scope-and-content-cs.md)
* [PatientHistory Relationships](PatientHistory-map.md)
* [Obligations](obligations-cs.md)
* [HospitalDischargeReport Relationships](HospitalDischargeReport-map.md)
* [AdmissionEvaluation Relationships](AdmissionEvaluation-map.md)
* [Datová sada - logické modely CZ](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Implementation notes](implementation-notes.md)
* [InPatientEncounter Relationships](InPatientEncounter-map.md)
* [Dependencies](dependencies.md)
* [ObjectiveFindings Relationships](ObjectiveFindings-map.md)
* [Copyright](copyright.md)
* [Background](background.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [PlanOfCare Relationships](PlanOfCare-map.md)
* [Authors](authors.md)
* [Ke stažení](downloads-cs.md)
* [Model maps](model-map.md)
* [Mapování logického modelu](model-map-cs.md)
* [Alerts Relationships](Alerts-map.md)
* [Autoři](authors-cs.md)
* [Artifacts](artifacts.md)
* [Subject Relationships](Subject-map.md)
* [Downloads](downloads.md)
* [Header Relationships](Header-map.md)
* [HospitalStay Relationships](HospitalStay-map.md)
* [AdvanceDirectives Relationships](AdvanceDirectives-map.md)
* [Obligations](obligations.md)

## Resources

### CodeSystems

* [Temporary HDR Code System](CodeSystem-temporarySystem-hdr-cz.md)

### ValueSets

* [CZ Consent Category](ValueSet-cz-consent-category.md)
* [CZ Provision Code](ValueSet-cz-provision-code.md)
* [eHDSI Condition Present On Admission](ValueSet-eHDSIConditionPOA.md)
* [eHDSI Treatment Class](ValueSet-eHDSITreatmentClass.md)
* [Exposure of transmissible agents](ValueSet-exposureAgent-eu-hdr.md)
* [Related Person Relationship Types (HDR)](ValueSet-relatedPersonRelationshipTypes-eu-hdr.md)

### Logicals

* [A.2.4 - Admission evaluation (eHN)](StructureDefinition-AdmissionEvaluationEhnEn.md)
* [A.2.1 - Advance Directives (eHN)](StructureDefinition-AdvanceDirectivesCz.md)
* [A.2.2 - Alerts (eHN)](StructureDefinition-AlertsCz.md)
* [A.4 - Additional attachments](StructureDefinition-AttachmentsCz.md)
* [A.2.7 - Discharge details (eHN)](StructureDefinition-DischargeDetailsCz.md)
* [A.2.8.2 - Functional status](StructureDefinition-FunctionalStatusCz.md)
* [A.1 - Hospital Discharge Report header data element](StructureDefinition-Header.md)
* [A - Hospital Discharge Report (eHN)](StructureDefinition-HospitalDischargeReportCz.md)
* [A.2.6 - Hospital stay (eHN)](StructureDefinition-HospitalStayCz.md)
* [A.2.3 - Encounter (eHN)](StructureDefinition-InPatientEncounterCz.md)
* [A.2.4 - Stav při přijetí (cz)](StructureDefinition-LogAdmissionEvaluationCz.md)
* [A.2.1 - Dříve vyslovená přání (cz)](StructureDefinition-LogAdvanceDirectivesCz.md)
* [A.2.2 - Urgentní informace (cz)](StructureDefinition-LogAlertsCz.md)
* [A.4 - Přílohy (cz)](StructureDefinition-LogAttachmentsCz.md)
* [A.2.8.1 Objektivní nález](StructureDefinition-LogCzObjectiveFindingsCz.md)
* [A.2.7 - Průběh hospitalizace](StructureDefinition-LogDischargeDetailsCz.md)
* [A.2.8.2 - Funkční stav při propuštění](StructureDefinition-LogFunctionalStatusCz.md)
* [A.1 – Hlavička dokumentu](StructureDefinition-LogHeaderHdrCz.md)
* [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)
* [A.2.7 Průběh hospitalizace](StructureDefinition-LogHospitalStayCz.md)
* [A.2.3 - Kontakt se zdravotními službami](StructureDefinition-LogInPatientEncounterCz.md)
* [A.2.9.2 Souhrn medikace](StructureDefinition-LogMedicationSummaryCz.md)
* [A.2.6 - Anamnéza](StructureDefinition-LogPatientHistoryCz.md)
* [A.2.9.1 Plán péče](StructureDefinition-LogPlanOfCareCz.md)
* [A.3 - Vizuální podoba dokumentu](StructureDefinition-LogPresentedFormCz.md)
* [A.1.1 - Identifikace a A.1.2 - informace o pacientovi](StructureDefinition-LogSubjectCz.md)
* [A.1.9 - Digitální podpis](StructureDefinition-LogdigitalSignatureCz.md)
* [A.2.8.2 - Medication summary](StructureDefinition-MedicationSummaryCz.md)
* [A.2.7.1 - Objective findings](StructureDefinition-ObjectiveFindingsCz.md)
* [A.2.5 - Patient history (eHN)](StructureDefinition-PatientHistoryCz.md)
* [A.2.8.1 - Care plan](StructureDefinition-PlanOfCareCz.md)
* [A.3 - Presented form](StructureDefinition-PresentedFormCz.md)
* [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md)
* [A.1.9 - Digital signature](StructureDefinition-digitalSignatureCz.md)

### Complex-type Profiles

* [Address Obligations (HDR CZ)](StructureDefinition-cz-address-obl-hdr.md)
* [Dosage: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-dosage-hospitalstay-obl-hdr.md)
* [Dosage: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-dosage-medicationsummary-obl-hdr.md)

### Resource Profiles

* [Allergy Intolerance (HDR CZ)](StructureDefinition-cz-allergyIntolerance-hdr.md)
* [Allergy Intolerance Obligations (HDR CZ)](StructureDefinition-cz-allergyintolerance-obl-hdr.md)
* [Attachment: HDR (CZ)](StructureDefinition-cz-attachment-hdr.md)
* [Attachments: Obligations](StructureDefinition-cz-attachment-obl-hdr.md)
* [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* [Care Plan (HDR CZ)](StructureDefinition-cz-carePlan-hdr.md)
* [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* [Composition: Obligations](StructureDefinition-cz-composition-obl-hdr.md)
* [Condition (HDR CZ)](StructureDefinition-cz-condition-hdr.md)
* [Consent (Advance Directives) (HDR CZ)](StructureDefinition-cz-consent-hdr.md)
* [Consent Obligations (HDR CZ)](StructureDefinition-cz-consent-obl-hdr.md)
* [Coverage: Obligations](StructureDefinition-cz-coverage-obl-hdr.md)
* [DeviceUseStatement (HDR)](StructureDefinition-cz-deviceUseStatement-hdr.md)
* [Encounter (HDR CZ)](StructureDefinition-cz-encounter-hdr.md)
* [Encounter: Obligations](StructureDefinition-cz-encounter-obl-hdr.md)
* [FamilyMemberHistory (HDR CZ)](StructureDefinition-cz-familyMemberHistory-hdr.md)
* [Flag (HDR CZ)](StructureDefinition-cz-flag-hdr.md)
* [Flag Obligations (HDR CZ)](StructureDefinition-cz-flag-obl-hdr.md)
* [Immunization (HDR CZ)](StructureDefinition-cz-immunization-hdr.md)
* [Immunization Obligations: HDR CZ](StructureDefinition-cz-immunization-obl-hdr.md)
* [ImmunizationRecommendation (CZ HDR)](StructureDefinition-cz-immunizationRecommendation-hdr.md)
* [Immunization Recommendation Obligations (HDR CZ)](StructureDefinition-cz-immunizationrecommendation-obl-hdr.md)
* [Medical Device: Obligations](StructureDefinition-cz-medicalDevice-obl-hdr.md)
* [Medication Obligations: (HDR CZ) - hospital stay](StructureDefinition-cz-medication-hospitalstay-obl-hdr.md)
* [Medication Obligations: (HDR CZ) - medication summary](StructureDefinition-cz-medication-medicationsummary-obl-hdr.md)
* [MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md)
* [MedicationRequest (HDR CZ)](StructureDefinition-cz-medicationRequest-hdr.md)
* [Medication Administration Obligations (HDR CZ)](StructureDefinition-cz-medicationadministration-obl-hdr.md)
* [MedicationDispense: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationdispens-hospitalstay-obl-hdr.md)
* [MedicationDispense: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationdispens-medicationsummary-obl-hdr.md)
* [MedicationRequest: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md)
* [MedicationRequest: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md)
* [MedicationStatement: Obligations (HDR CZ)](StructureDefinition-cz-medicationstatement-obl-hdr.md)
* [Observation: Anthropometric Data (HDR CZ) - BMI](StructureDefinition-cz-observation-BMI-hdr.md)
* [Observation: Anthropometric Data (HDR CZ) - Abdominal Circumference](StructureDefinition-cz-observation-abdominalCircumference-hdr.md)
* [Observations: Anthropometric Data obligations](StructureDefinition-cz-observation-anthropometricdata-obl-hdr.md)
* [Observation: Anthropometric Data (HDR CZ) - Chest Circumference](StructureDefinition-cz-observation-chestCircumference-hdr.md)
* [Observation: Anthropometric Data (HDR CZ) - Head Circumference](StructureDefinition-cz-observation-headCircumference-hdr.md)
* [Observation: Anthropometric Data (HDR CZ) - Height](StructureDefinition-cz-observation-height-hdr.md)
* [Observations: Infectious Contact obligations](StructureDefinition-cz-observation-ic-obl-hdr.md)
* [Observation: Infectious Contact (HDR CZ)](StructureDefinition-cz-observation-infectious-contact-hdr.md)
* [Observation: SDOH (HDR CZ)](StructureDefinition-cz-observation-sdoh-hdr.md)
* [Observation: travel history (HDR CZ)](StructureDefinition-cz-observation-travel-hdr.md)
* [Observation: Anthropometric Data (HDR CZ)](StructureDefinition-cz-observation-weight-hdr.md)
* [Organization: Obligations](StructureDefinition-cz-organization-obl-hdr.md)
* [Patient: Obligations](StructureDefinition-cz-patient-obl-hdr.md)
* [Practitioner: Obligations](StructureDefinition-cz-practitioner-obl-hdr.md)
* [Practitioner Role: Obligations](StructureDefinition-cz-practitionerRole-obl-hdr.md)
* [Procedure (HDR CZ)](StructureDefinition-cz-procedure-hdr.md)
* [Procedure: Obligations](StructureDefinition-cz-procedure-obl-hdr.md)
* [Related Person: HDR (CZ)](StructureDefinition-cz-relatedPerson-hdr.md)
* [Related Person: Obligations](StructureDefinition-cz-relatedPerson-obl-hdr.md)

### ConceptMaps

* [CZ Attachment Model to this guide Map](ConceptMap-AttachmentHDR2FHIR-cz.md)
* [CZ Advance Directives Model to this guide Map](ConceptMap-advanceDirectives2FHIR-cz-hdr.md)
* [CZ Alerts Model to this guide Map](ConceptMap-alerts2FHIR-cz-hdr.md)
* [eHN Encounter Model to this guide Map](ConceptMap-encounter2FHIR-cz-hdr.md)
* [eHN Functional Status Model to this guide Map](ConceptMap-functionalStatus2FHIR-hdr-cz.md)
* [CZ HDR Model to this guide Map](ConceptMap-hdr2FHIR-cz-hdr.md)
* [CZ Header Model to this guide Map](ConceptMap-hdrHeader2FHIR-cz-hdr.md)
* [eHN Hospital Stay Model to this guide Map](ConceptMap-hospitalStay2FHIR-cz-hdr.md)
* [eHN Medication Summary Model to this guide Map](ConceptMap-medicationSummary2FHIR-cz-hdr.md)
* [eHN Objective Findings Model to this guide Map](ConceptMap-objectiveFindings2FHIR-hdr-cz.md)
* [CZ Patient History to this guide Map](ConceptMap-patientHistory2FHIR-cz-hdr.md)
* [eHN Plan of Care Model to this guide Map](ConceptMap-planOfCare2FHIR-cz-hdr.md)
* [eHN Subject Model to this guide Map](ConceptMap-subject2FHIR-cz-hdr.md)

### ImplementationGuides

* [HL7 Czech Hospital Discharge Report Implementation Guide](index.md)

### Examples

* [6cf80cb1-9766-470f-ac36-b1d3d8950f1b (AllergyIntolerance)](AllergyIntolerance-6cf80cb1-9766-470f-ac36-b1d3d8950f1b.md)
* [AllergyInfoUnknown (AllergyIntolerance)](AllergyIntolerance-AllergyInfoUnknown.md)
* [MilkAllergy (AllergyIntolerance)](AllergyIntolerance-MilkAllergy.md)
* [NoKnownAllergy (AllergyIntolerance)](AllergyIntolerance-NoKnownAllergy.md)
* [PenicillinAllergy (AllergyIntolerance)](AllergyIntolerance-PenicillinAllergy.md)
* [StrawberryAllergy (AllergyIntolerance)](AllergyIntolerance-StrawberryAllergy.md)
* [DischargeBundle-Novak-Petr-L1-core (Bundle)](Bundle-DischargeBundle-Novak-Petr-L1-core.md)
* [DischargeBundle-Novak-Petr-L1-plus (Bundle)](Bundle-DischargeBundle-Novak-Petr-L1-plus.md)
* [DischargeBundle-Novak-Petr-L1 (Bundle)](Bundle-DischargeBundle-Novak-Petr-L1.md)
* [DischargeBundle-Novak-Petr-Subsections (Bundle)](Bundle-DischargeBundle-Novak-Petr-Subsections.md)
* [DischargeBundle-Novak-Petr (Bundle)](Bundle-DischargeBundle-Novak-Petr.md)
* [Plán péče – tříselná kýla (CarePlan)](CarePlan-9c913d06-84fe-4d35-b35b-8b0c7965f535.md)
* [Post-Discharge Care Plan (CarePlan)](CarePlan-CZ-CarePlan-HDR-Example.md)
* [Propouštěcí zpráva z nemocnice (Composition)](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c035.md)
* [Propouštěcí zpráva (Composition)](Composition-6891fd68-dc3c-4c91-a8d3-cb5ec990c03b.md)
* [Propouštěcí zpráva (Composition)](Composition-701f51d5-78bf-428e-a6b5-349c2614ce07.md)
* [Propouštěcí zpráva (Composition)](Composition-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaaf.md)
* [35717696-8a99-4f99-a938-ec0ec88a65a2 (Condition)](Condition-35717696-8a99-4f99-a938-ec0ec88a65a2.md)
* [AngiodysplasiaCondition (Condition)](Condition-AngiodysplasiaCondition.md)
* [AtrialFibrillationCondition (Condition)](Condition-AtrialFibrillationCondition.md)
* [CZ-Condition-HDR-Example-2 (Condition)](Condition-CZ-Condition-HDR-Example-2.md)
* [CZ-Condition-HDR-Example-3 (Condition)](Condition-CZ-Condition-HDR-Example-3.md)
* [CZ-Condition-HDR-Example (Condition)](Condition-CZ-Condition-HDR-Example.md)
* [HypercholesterolemiaCondition (Condition)](Condition-HypercholesterolemiaCondition.md)
* [HypothyroidismCondition (Condition)](Condition-HypothyroidismCondition.md)
* [IronDeficiencyAnemiaCondition (Condition)](Condition-IronDeficiencyAnemiaCondition.md)
* [OsteoporosisCondition (Condition)](Condition-OsteoporosisCondition.md)
* [PresbycusisCondition (Condition)](Condition-PresbycusisCondition.md)
* [TIACondition (Condition)](Condition-TIACondition.md)
* [VaricoseVeinsCondition (Condition)](Condition-VaricoseVeinsCondition.md)
* [fdf9e92d-ac48-4706-b15b-d2eaca85f45f (Condition)](Condition-fdf9e92d-ac48-4706-b15b-d2eaca85f45f.md)
* [CZ-AdvanceDirectives-HDR-CORE (Consent)](Consent-CZ-AdvanceDirectives-HDR-CORE.md)
* [CZ-AdvanceDirectives-HDR-DNR (Consent)](Consent-CZ-AdvanceDirectives-HDR-DNR.md)
* [Device-Pacemaker (Device)](Device-Device-Pacemaker.md)
* [DeviceUseStatement-Pacemaker (DeviceUseStatement)](DeviceUseStatement-DeviceUseStatement-Pacemaker.md)
* [66678621-df93-47ca-a36c-2a39a92472e7 (DocumentReference)](DocumentReference-66678621-df93-47ca-a36c-2a39a92472e7.md)
* [d9ad8a22-a12b-48db-938c-4066a3a0617a (DocumentReference)](DocumentReference-d9ad8a22-a12b-48db-938c-4066a3a0617a.md)
* [10f5c49e-086d-4016-8dd1-b555306bf620 (Encounter)](Encounter-10f5c49e-086d-4016-8dd1-b555306bf620.md)
* [CZ-Encounter-HDR-Example (Encounter)](Encounter-CZ-Encounter-HDR-Example.md)
* [HospitalEncounter (Encounter)](Encounter-HospitalEncounter.md)
* [f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb (Encounter)](Encounter-f08151d0-a7ad-4a7b-b7b9-97eb1d394ffb.md)
* [5a17a710-193e-4490-a627-7202925aa56e (Flag)](Flag-5a17a710-193e-4490-a627-7202925aa56e.md)
* [Flag1 (Flag)](Flag-Flag1.md)
* [620b1120-cece-44b1-89f5-20413054eb1d (Goal)](Goal-620b1120-cece-44b1-89f5-20413054eb1d.md)
* [3f85726c-ad2f-441b-89ce-10000000001e (Immunization)](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md)
* [Immunization-CovidExample (Immunization)](Immunization-Immunization-CovidExample.md)
* [ImmunizationRecommendation (ImmunizationRecommendation)](ImmunizationRecommendation-ImmunizationRecommendation.md)
* [Nemocnice Praha - Klinika Chirurgie (Location)](Location-Location-5.md)
* [Nemocnice Chrudim - Oddělení CHIR1 (Location)](Location-cz-Location-Chrudim-Chir1.md)
* [Nemocnice Chrudim - Oddělení CHIR-JIP (Location)](Location-cz-Location-Chrudim-ChirJIP.md)
* [Nemocnice Praha (Location)](Location-example-cz-location.md)
* [Nemocnice Praha - Oddělení A (Location)](Location-sample-cz-location-2.md)
* [Nemocnice Praha - Oddělení B (Location)](Location-sample-cz-location-3.md)
* [Nemocnice Praha - Oddělení C (Location)](Location-sample-cz-location-4.md)
* [Medication-Euthyrox (Medication)](Medication-Medication-Euthyrox.md)
* [med-CovidVaccineComirnaty (Medication)](Medication-med-CovidVaccineComirnaty.md)
* [med-Ibalgin400 (Medication)](Medication-med-Ibalgin400.md)
* [med-paracetamol (Medication)](Medication-med-paracetamol.md)
* [MedicationDispense-Euthyrox (MedicationDispense)](MedicationDispense-MedicationDispense-Euthyrox.md)
* [MedicationDispense-Ibalgin400 (MedicationDispense)](MedicationDispense-MedicationDispense-Ibalgin400.md)
* [MedicationDispense-Paracetamol (MedicationDispense)](MedicationDispense-MedicationDispense-Paracetamol.md)
* [47472c99-09bf-4007-bfaa-16c9665ae090 (MedicationStatement)](MedicationStatement-47472c99-09bf-4007-bfaa-16c9665ae090.md)
* [AtorvastatinMedication (MedicationStatement)](MedicationStatement-AtorvastatinMedication.md)
* [BisoprololMedication (MedicationStatement)](MedicationStatement-BisoprololMedication.md)
* [CalciumD3Medication (MedicationStatement)](MedicationStatement-CalciumD3Medication.md)
* [IronSupplementMedication (MedicationStatement)](MedicationStatement-IronSupplementMedication.md)
* [LevothyroxineMedication (MedicationStatement)](MedicationStatement-LevothyroxineMedication.md)
* [RivaroxabanMedication (MedicationStatement)](MedicationStatement-RivaroxabanMedication.md)
* [bf08b62b-0abd-4e88-9092-ce0228382e51 (MedicationStatement)](MedicationStatement-bf08b62b-0abd-4e88-9092-ce0228382e51.md)
* [f34114fc-138f-4bd8-8e1a-804d14ec9986 (MedicationStatement)](MedicationStatement-f34114fc-138f-4bd8-8e1a-804d14ec9986.md)
* [10f5c49e-086d-4016-8dd1-10000000001b (Observation)](Observation-10f5c49e-086d-4016-8dd1-10000000001b.md)
* [3f85726c-ad2f-441b-89ce-10000000001c (Observation)](Observation-3f85726c-ad2f-441b-89ce-10000000001c.md)
* [3f85726c-ad2f-441b-89ce-10000000001d (Observation)](Observation-3f85726c-ad2f-441b-89ce-10000000001d.md)
* [3f85726c-ad2f-441b-89ce-100000000021 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000021.md)
* [3f85726c-ad2f-441b-89ce-100000000022 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000022.md)
* [3f85726c-ad2f-441b-89ce-100000000023 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000023.md)
* [3f85726c-ad2f-441b-89ce-100000000024 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000024.md)
* [3f85726c-ad2f-441b-89ce-100000000025 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000025.md)
* [3f85726c-ad2f-441b-89ce-100000000027 (Observation)](Observation-3f85726c-ad2f-441b-89ce-100000000027.md)
* [4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a (Observation)](Observation-4ba395b7-be9e-4bed-bef7-1c8f0b2d4e3a.md)
* [5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c (Observation)](Observation-5c2ddf62-9785-493f-80c6-8b0d1e3a4b2c.md)
* [5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d (Observation)](Observation-5c363e2d-c4e1-436d-bad7-0b3f8c6a9f1d.md)
* [6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b (Observation)](Observation-6bec5d97-a17e-4015-8fce-7b1c0c3a2f4b.md)
* [6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a (Observation)](Observation-6c626338-82ba-46a1-bcb8-2c8f0b2d4e3a.md)
* [7cf304de-5ae3-4621-8531-9c8f0b2d4e3a (Observation)](Observation-7cf304de-5ae3-4621-8531-9c8f0b2d4e3a.md)
* [8d2aea77-f576-4d0f-9508-537359aa44d6 (Observation)](Observation-8d2aea77-f576-4d0f-9508-537359aa44d6.md)
* [CZObservationSdohHdrExample (Observation)](Observation-CZObservationSdohHdrExample.md)
* [ExampleSdohAlcohol (Observation)](Observation-ExampleSdohAlcohol.md)
* [ExampleSdohSmoking (Observation)](Observation-ExampleSdohSmoking.md)
* [Observation-Education-level (Observation)](Observation-Observation-Education-level.md)
* [Observation-InfectiousContact (Observation)](Observation-Observation-InfectiousContact.md)
* [Observation-TravelHistory-Madagaskar (Observation)](Observation-Observation-TravelHistory-Madagaskar.md)
* [bloodcount-panel (Observation)](Observation-bloodcount-panel.md)
* [e15aeeaf-e288-404c-9704-9c8f0b2d4e3a (Observation)](Observation-e15aeeaf-e288-404c-9704-9c8f0b2d4e3a.md)
* [hb-result (Observation)](Observation-hb-result.md)
* [hct-result (Observation)](Observation-hct-result.md)
* [plt-result (Observation)](Observation-plt-result.md)
* [rbc-result (Observation)](Observation-rbc-result.md)
* [wbc-result (Observation)](Observation-wbc-result.md)
* [Nemocnice Pardubického kraje, a.s., Chrudimská nemocnice (Organization)](Organization-9f7c3d74-2c71-4b92-9a59-2b6f37ecb3d1.md)
* [Hematologická laboratoř Brno (Organization)](Organization-Lab-HematologieBrno.md)
* [Pfizer s.r.o. (Organization)](Organization-Organization-Pfizer.md)
* [Ambulance interního lékařství, MUDr. Jiří Zdvořilý (Organization)](Organization-Organization-Referrer.md)
* [MUDr. Jana Kouzelná (Organization)](Organization-RegisteringProviderExample-gynecology.md)
* [MUDr. Jana Krásná (Organization)](Organization-RegisteringProviderExample.md)
* [CHIR-L2 - Lůžková stanice 2 (Organization)](Organization-a4641bd0-34af-4038-a7db-872d08a54df9.md)
* [Nemocnice Chrudim (Organization)](Organization-ace081ba-e0a8-4b89-a4a7-c5b7cd3c8169.md)
* [CHIR - Oddělení chirurgie (Organization)](Organization-af2b3114-e872-43b9-9875-cceb39122f7f.md)
* [3f85726c-ad2f-441b-89ce-100000000000 (Patient)](Patient-3f85726c-ad2f-441b-89ce-100000000000.md)
* [48a9d440-4194-42c1-87ad-b5a39020a4d0 (Patient)](Patient-48a9d440-4194-42c1-87ad-b5a39020a4d0.md)
* [Mracena (Patient)](Patient-Mracena.md)
* [Mracena2 (Patient)](Patient-Mracena2.md)
* [860c684f-aba1-40d9-94cf-721d70237b52 (Practitioner)](Practitioner-860c684f-aba1-40d9-94cf-721d70237b52.md)
* [Practitioner-2 (Practitioner)](Practitioner-Practitioner-2.md)
* [Practitioner-Admitter (Practitioner)](Practitioner-Practitioner-Admitter.md)
* [Practitioner-L1 (Practitioner)](Practitioner-Practitioner-L1.md)
* [Practitioner-Referrer (Practitioner)](Practitioner-Practitioner-Referrer.md)
* [Sova (Practitioner)](Practitioner-Sova.md)
* [Sovak (Practitioner)](Practitioner-Sovak.md)
* [a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a (Practitioner)](Practitioner-a81e74c9-fe94-4eb1-9233-4c8f0b2d4e3a.md)
* [e234a53a-4e0d-4fb8-9403-e0e324a50f64 (Practitioner)](Practitioner-e234a53a-4e0d-4fb8-9403-e0e324a50f64.md)
* [2b7e9637-5018-4542-9faf-d5abdee7b849 (PractitionerRole)](PractitionerRole-2b7e9637-5018-4542-9faf-d5abdee7b849.md)
* [69d34ceb-b556-4f75-9e4c-9184fe8a10c5 (PractitionerRole)](PractitionerRole-69d34ceb-b556-4f75-9e4c-9184fe8a10c5.md)
* [Practitioner-Referrer-detail (PractitionerRole)](PractitionerRole-Practitioner-Referrer-detail.md)
* [practitionerrole1 (PractitionerRole)](PractitionerRole-practitionerrole1.md)
* [CZ-Procedure-HDR-Example-Acute-appendicitis (Procedure)](Procedure-CZ-Procedure-HDR-Example-Acute-appendicitis.md)
* [ColonoscopyProcedure (Procedure)](Procedure-ColonoscopyProcedure.md)
* [Procedure-Appendectomy (Procedure)](Procedure-Procedure-Appendectomy.md)
* [Procedure-Insert-Pacemaker (Procedure)](Procedure-Procedure-Insert-Pacemaker.md)
* [Procedure-Insert-Pacemaker2 (Procedure)](Procedure-Procedure-Insert-Pacemaker2.md)
* [Procedure-No-Procedure (Procedure)](Procedure-Procedure-No-Procedure.md)
* [ffb1a62f-9050-4e33-af4b-4cdb8203c9e5 (Procedure)](Procedure-ffb1a62f-9050-4e33-af4b-4cdb8203c9e5.md)
* [cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab (Provenance)](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eaab.md)
* [cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb (Provenance)](Provenance-cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb.md)
* [Specimen-EDTA-1 (Specimen)](Specimen-Specimen-EDTA-1.md)
