# MedicationRequest (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **MedicationRequest (HDR CZ)**

## Resource Profile: MedicationRequest (HDR CZ) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr | *Version*:0.1.0 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CZ_MedicationRequestHdr |

 
This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work. 

**Usages:**

* Derived from this Profile: [MedicationRequest: Obligations (HDR CZ) - hospital stay](StructureDefinition-cz-medicationrequest-hospitalstay-obl-hdr.md) and [MedicationRequest: Obligations (HDR CZ) - medication summary](StructureDefinition-cz-medicationrequest-medicationsummary-obl-hdr.md)
* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md) and [MedicationDispense (HDR)](StructureDefinition-cz-medicationDispense-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-medicationRequest-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-medicationRequest-hdr.csv), [Excel](StructureDefinition-cz-medicationRequest-hdr.xlsx), [Schematron](StructureDefinition-cz-medicationRequest-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-medicationRequest-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-medicationRequest-hdr",
  "version" : "0.1.0",
  "name" : "CZ_MedicationRequestHdr",
  "title" : "MedicationRequest (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest.identifier",
        "path" : "MedicationRequest.identifier",
        "short" : "Prescription/prescribed item ID",
        "comment" : "It is the prescription ID if the presciption includes only one prescribed item"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "short" : "Current state of the order"
      },
      {
        "id" : "MedicationRequest.medication[x]",
        "path" : "MedicationRequest.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationRequest.medication[x]:medicationReference",
        "path" : "MedicationRequest.medication[x]",
        "sliceName" : "medicationReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.reasonCode",
        "path" : "MedicationRequest.reasonCode",
        "short" : "Reason or indication for this prescription"
      },
      {
        "id" : "MedicationRequest.reasonReference",
        "path" : "MedicationRequest.reasonReference",
        "short" : "Condition or observation that supports this prescription"
      },
      {
        "id" : "MedicationRequest.groupIdentifier",
        "path" : "MedicationRequest.groupIdentifier",
        "short" : "Prescription this is part of",
        "comment" : "Not needed if a presciption includes only one prescribed item"
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "short" : "How the medication should be taken."
      },
      {
        "id" : "MedicationRequest.dosageInstruction.text",
        "path" : "MedicationRequest.dosageInstruction.text",
        "short" : "Free text dosage instructions"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing",
        "path" : "MedicationRequest.dosageInstruction.timing",
        "short" : "Administration schedule"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "short" : "Duration of the treatment"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "Frequency times per period"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "short" : "Duration of time over which repetitions are to occur"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "Unit of the period (e.g. day)"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code",
        "path" : "MedicationRequest.dosageInstruction.timing.code",
        "short" : "A code for the timing schedule."
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "short" : "Route of administration"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]:doseQuantity",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "sliceName" : "doseQuantity",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]:allowedCodeableConcept",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "sliceName" : "allowedCodeableConcept",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
