# Immunization (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Immunization (HDR CZ)**

## Resource Profile: Immunization (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ImmunizationHdr |

 
This profile constrains the Immunization resource for the purpose of this guide. 

 
This profile constrains the Immunization resource for the purpose of this guide. 

**Usages:**

* Derived from this Profile: [Immunization Obligations: HDR CZ](StructureDefinition-cz-immunization-obl-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)
* Examples for this Profile: [Immunization/3f85726c-ad2f-441b-89ce-10000000001e](Immunization-3f85726c-ad2f-441b-89ce-10000000001e.md) and [Immunization/Immunization-CovidExample](Immunization-Immunization-CovidExample.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-immunization-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-immunization-hdr.csv), [Excel](StructureDefinition-cz-immunization-hdr.xlsx), [Schematron](StructureDefinition-cz-immunization-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-immunization-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Immunization-uv-ips|2.0.0"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunization-hdr",
  "version" : "0.1.0",
  "name" : "CZ_ImmunizationHdr",
  "title" : "Immunization (HDR CZ)",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Immunization resource for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "purpose" : "This profile constrains the Immunization resource for the purpose of this guide.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Immunization",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Immunization",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Immunization",
        "path" : "Immunization"
      },
      {
        "id" : "Immunization.extension",
        "path" : "Immunization.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.extension:basedOn",
        "path" : "Immunization.extension",
        "sliceName" : "basedOn",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Immunization.basedOn"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.extension:basedOn.value[x]",
        "path" : "Immunization.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-immunizationRecommendation-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.extension:administeredProduct",
        "path" : "Immunization.extension",
        "sliceName" : "administeredProduct",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/hdr/StructureDefinition/immunization-administeredProduct"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.extension:administeredProduct.extension:reference",
        "path" : "Immunization.extension.extension",
        "sliceName" : "reference"
      },
      {
        "id" : "Immunization.extension:administeredProduct.extension:reference.value[x]",
        "path" : "Immunization.extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "Immunization.vaccineCode",
        "path" : "Immunization.vaccineCode",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-whoatc-uv-ips|2.0.0"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Additional conformance binding to a vaccines value set from the WHO ATC code system for use in specific jurisdictional or other contexts where use of the ATC terminology is preferred."
                },
                {
                  "url" : "shortDoco",
                  "valueString" : "For when WHO ATC code system is preferred"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "description" : "The type of vaccine for particular disease or diseases against which the patient has been immunised, or a code for absent/unknown immunization.",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/vaccines-uv-ips|2.0.0"
        }
      },
      {
        "id" : "Immunization.patient",
        "path" : "Immunization.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.occurrence[x]",
        "path" : "Immunization.occurrence[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Immunization.location",
        "path" : "Immunization.location",
        "short" : "Location"
      },
      {
        "id" : "Immunization.manufacturer",
        "path" : "Immunization.manufacturer",
        "short" : "Vaccine manufacturer/MAH"
      },
      {
        "id" : "Immunization.lotNumber",
        "path" : "Immunization.lotNumber",
        "short" : "Batch/lot number"
      },
      {
        "id" : "Immunization.performer",
        "path" : "Immunization.performer",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this.function"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.performer:administeringCentre",
        "path" : "Immunization.performer",
        "sliceName" : "administeringCentre",
        "short" : "Administering centre",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Immunization.performer:administeringCentre.function",
        "path" : "Immunization.performer.function",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
              "code" : "AP"
            }
          ]
        }
      },
      {
        "id" : "Immunization.performer:administeringCentre.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core|2.0.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.performer:administeringHp",
        "path" : "Immunization.performer",
        "sliceName" : "administeringHp",
        "short" : "Administering Health Professional",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Immunization.performer:administeringHp.function",
        "path" : "Immunization.performer.function",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0443",
              "code" : "AP"
            }
          ]
        }
      },
      {
        "id" : "Immunization.performer:administeringHp.actor",
        "path" : "Immunization.performer.actor",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core|2.0.0-ballot",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core|2.0.0-ballot"
            ]
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.targetDisease",
        "path" : "Immunization.protocolApplied.targetDisease",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/condition-eu-hdr"
        }
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber[x]",
        "path" : "Immunization.protocolApplied.doseNumber[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.protocolApplied.doseNumber[x]:doseNumberPositiveInt",
        "path" : "Immunization.protocolApplied.doseNumber[x]",
        "sliceName" : "doseNumberPositiveInt",
        "short" : "Dose Number",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "Immunization.protocolApplied.seriesDoses[x]",
        "path" : "Immunization.protocolApplied.seriesDoses[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Immunization.protocolApplied.seriesDoses[x]:seriesDosesPositiveInt",
        "path" : "Immunization.protocolApplied.seriesDoses[x]",
        "sliceName" : "seriesDosesPositiveInt",
        "short" : "Number of doses",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      }
    ]
  }
}

```
