# FamilyMemberHistory (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **FamilyMemberHistory (HDR CZ)**

## Resource Profile: FamilyMemberHistory (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_FamilyMemberHistoryHdr |

 
This profile represents the constraints applied to the FamilyMemberHistory resource by this guide. 

**Usages:**

* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-familyMemberHistory-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-familyMemberHistory-hdr.csv), [Excel](StructureDefinition-cz-familyMemberHistory-hdr.xlsx), [Schematron](StructureDefinition-cz-familyMemberHistory-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-familyMemberHistory-hdr",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-familyMemberHistory-hdr",
  "version" : "0.1.0",
  "name" : "CZ_FamilyMemberHistoryHdr",
  "title" : "FamilyMemberHistory (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the FamilyMemberHistory resource by this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "FamilyMemberHistory",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/FamilyMemberHistory",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "FamilyMemberHistory",
        "path" : "FamilyMemberHistory"
      },
      {
        "id" : "FamilyMemberHistory.dataAbsentReason",
        "path" : "FamilyMemberHistory.dataAbsentReason",
        "short" : "Reason for missing data"
      },
      {
        "id" : "FamilyMemberHistory.patient",
        "path" : "FamilyMemberHistory.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "FamilyMemberHistory.relationship",
        "path" : "FamilyMemberHistory.relationship",
        "short" : "Relationship to the subject."
      },
      {
        "id" : "FamilyMemberHistory.born[x]",
        "path" : "FamilyMemberHistory.born[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "FamilyMemberHistory.born[x]:bornDate",
        "path" : "FamilyMemberHistory.born[x]",
        "sliceName" : "bornDate",
        "short" : "Date of birth of the relative",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "FamilyMemberHistory.deceased[x]",
        "path" : "FamilyMemberHistory.deceased[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "FamilyMemberHistory.deceased[x]:deceasedAge",
        "path" : "FamilyMemberHistory.deceased[x]",
        "sliceName" : "deceasedAge",
        "short" : "(Approximate) age at death of the relative",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Age"
          }
        ]
      },
      {
        "id" : "FamilyMemberHistory.deceased[x]:deceasedDate",
        "path" : "FamilyMemberHistory.deceased[x]",
        "sliceName" : "deceasedDate",
        "short" : "Date of death of the relative",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "FamilyMemberHistory.condition.code",
        "path" : "FamilyMemberHistory.condition.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips|2.0.0"
            ]
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.eu/fhir/hdr/ValueSet/condition-eu-hdr"
        }
      },
      {
        "id" : "FamilyMemberHistory.condition.note",
        "path" : "FamilyMemberHistory.condition.note",
        "short" : "Extra information about this condition"
      }
    ]
  }
}

```
