# Coverage: Obligations - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Coverage: Obligations**

## Resource Profile: Coverage: Obligations 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-coverage-obl-hdr | *Version*:0.1.0 | |
| *Standards status:*[Informative](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 0 | *Computable Name*:CZ_CoverageObligationsHdr |

 
This profile defines obligations for a coverage in FHIR for the purpose of this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-coverage-obl-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-coverage-obl-hdr.csv), [Excel](StructureDefinition-cz-coverage-obl-hdr.xlsx), [Schematron](StructureDefinition-cz-coverage-obl-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-coverage-obl-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 0
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "informative"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-coverage-obl-hdr",
  "version" : "0.1.0",
  "name" : "CZ_CoverageObligationsHdr",
  "title" : "Coverage: Obligations",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines obligations for a coverage in FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "cdanetv4",
      "uri" : "http://www.cda-adc.ca/en/services/cdanet/",
      "name" : "Canadian Dental Association eclaims standard"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "cpha3pharm",
      "uri" : "http://www.pharmacists.ca/",
      "name" : "Canadian Pharmacy Associaiton eclaims standard"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Coverage",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-coverage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Coverage",
        "path" : "Coverage"
      },
      {
        "id" : "Coverage.identifier",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.identifier"
      },
      {
        "id" : "Coverage.payor",
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L2"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:able-to-populate"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-creator-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCode" : "SHALL:display"
              },
              {
                "url" : "actor",
                "valueCanonical" : "https://hl7.cz/fhir/core/ActorDefinition/actor-consumer-L3"
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/obligation"
          }
        ],
        "path" : "Coverage.payor"
      }
    ]
  }
}

```
