# Care Plan (HDR CZ) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Care Plan (HDR CZ)**

## Resource Profile: Care Plan (HDR CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_CarePlanHdr |

 
This profile constrains the CarePlan resource for the purpose of this guide. 

**Usages:**

* Use this Profile: [Bundle (HDR CZ)](StructureDefinition-cz-bundle-hdr.md)
* Refer to this Profile: [Composition (HDR CZ)](StructureDefinition-cz-composition-hdr.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/cz-carePlan-hdr)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-carePlan-hdr.csv), [Excel](StructureDefinition-cz-carePlan-hdr.xlsx), [Schematron](StructureDefinition-cz-carePlan-hdr.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-carePlan-hdr",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.eu/fhir/hdr/StructureDefinition/carePlan-eu-hdr"
    }
  ],
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/cz-carePlan-hdr",
  "version" : "0.1.0",
  "name" : "CZ_CarePlanHdr",
  "title" : "Care Plan (HDR CZ)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile constrains the CarePlan resource for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan.title",
        "path" : "CarePlan.title",
        "short" : "Name for the care plan"
      },
      {
        "id" : "CarePlan.description",
        "path" : "CarePlan.description",
        "short" : "Summary of nature of plan."
      },
      {
        "id" : "CarePlan.period",
        "path" : "CarePlan.period",
        "short" : "Period covered by the plan"
      },
      {
        "id" : "CarePlan.addresses",
        "path" : "CarePlan.addresses",
        "short" : "Health issues this plan addresses.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/hdr/StructureDefinition/cz-condition-hdr"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.reference",
        "path" : "CarePlan.activity.reference",
        "short" : "Resources providing activity details"
      },
      {
        "id" : "CarePlan.activity.detail.kind",
        "path" : "CarePlan.activity.detail.kind",
        "short" : "Kind of resource referred"
      },
      {
        "id" : "CarePlan.activity.detail.description",
        "path" : "CarePlan.activity.detail.description",
        "short" : "Info describing activity to perform"
      }
    ]
  }
}

```
