# A.2.8.1 - Care plan - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.8.1 - Care plan**

## Logical Model: A.2.8.1 - Care plan 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/PlanOfCareCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnPlanOfCareHdrEhnCz |

 
Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/PlanOfCareCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PlanOfCareCz.csv), [Excel](StructureDefinition-PlanOfCareCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PlanOfCareCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/PlanOfCareCz",
  "version" : "0.1.0",
  "name" : "LogEnPlanOfCareHdrEhnCz",
  "title" : "A.2.8.1 - Care plan",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/PlanOfCareCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PlanOfCareCz",
        "path" : "PlanOfCareCz",
        "short" : "A.2.8.1 - Care plan",
        "definition" : "Hospital Discharge Report - Care plan after discharge - A.2.8.1 eHN"
      },
      {
        "id" : "PlanOfCareCz.title",
        "path" : "PlanOfCareCz.title",
        "short" : "A.2.9.1.1 - Title",
        "definition" : "Human-friendly name for the care plan (e.g. Hip replacement care plan)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.addresses",
        "path" : "PlanOfCareCz.addresses",
        "short" : "A.2.9.1.2 - Addresses",
        "definition" : "Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan. This element provides a linkage to the conditions recorded in the diagnostic summary section.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.description",
        "path" : "PlanOfCareCz.description",
        "short" : "A.2.9.1.3 - Description",
        "definition" : "A description of the scope and nature of the plan.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.planPeriod",
        "path" : "PlanOfCareCz.planPeriod",
        "short" : "A.2.9.1.4 - Plan Period",
        "definition" : "Indicates when the plan did (or is intended to) come into effect and end.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.details",
        "path" : "PlanOfCareCz.details",
        "short" : "A.2.9.1.5 - Other details",
        "definition" : "Other structured and coded details, care team, goals to be achieved.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.activity",
        "path" : "PlanOfCareCz.activity",
        "short" : "A.2.9.1.6 - Activity",
        "definition" : "Actions to occur as part of the plan.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.activity.kind",
        "path" : "PlanOfCareCz.activity.kind",
        "short" : "A.2.9.1.6.1 - Kind",
        "definition" : "A description of the type of care plan activity. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.activity.description",
        "path" : "PlanOfCareCz.activity.description",
        "short" : "A.2.9.1.6.2 - Activity description",
        "definition" : "A detailed description of the activity.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "PlanOfCareCz.activity.attribute",
        "path" : "PlanOfCareCz.activity.attribute",
        "short" : "A.2.9.1.6.3 - Specific attributes",
        "definition" : "Specific structured attributes per each activity type expressed by the Activity kind element, E.g., specific attributes for prescription request, appointment, etc.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
