# A.2.3 - Kontakt se zdravotními službami - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Kontakt se zdravotními službami**

## Logical Model: A.2.3 - Kontakt se zdravotními službami 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/LogInPatientEncounterCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzEncounterCz |

 
Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy. 

**Usages:**

* Use this Logical Model: [A - Propouštěcí zpráva](StructureDefinition-LogHospitalDischargeReportCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/LogInPatientEncounterCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogInPatientEncounterCz.csv), [Excel](StructureDefinition-LogInPatientEncounterCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogInPatientEncounterCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogInPatientEncounterCz",
  "version" : "0.1.0",
  "name" : "LogCzEncounterCz",
  "title" : "A.2.3 - Kontakt se zdravotními službami",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/LogInPatientEncounterCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogInPatientEncounterCz",
        "path" : "LogInPatientEncounterCz",
        "short" : "A.2.3 - Kontakt se zdravotními službami",
        "definition" : "Nemocniční propouštěcí zpráva - Záznam o hospitalizačním kontaktu v rámci propouštěcí zprávy."
      },
      {
        "id" : "LogInPatientEncounterCz.typ",
        "path" : "LogInPatientEncounterCz.typ",
        "short" : "A.2.3.1 - Typ kontaktu",
        "definition" : "Typ kontaktu (hospitalizace) - jednodenní, standardní. Zadáno při příjmu výběrem ze seznamu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.poznamka",
        "path" : "LogInPatientEncounterCz.poznamka",
        "short" : "A.2.3.2 - Poznámka k hospitalizaci",
        "definition" : "Poznámka k hospitalizaci volným textem. Zadáno při příjmu volným textem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem",
        "path" : "LogInPatientEncounterCz.prijem",
        "short" : "A.2.3.3 - Příjem",
        "definition" : "Informace o příjmu",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.urgentni",
        "path" : "LogInPatientEncounterCz.prijem.urgentni",
        "short" : "A.2.3.3.1 - Urgentnost přijetí",
        "definition" : "Akutní nebo plánovaný příjem. Zadáno při příjmu výběrem ze seznamu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.datum",
        "path" : "LogInPatientEncounterCz.prijem.datum",
        "short" : "A.2.3.3.2 - Datum a čas přijetí",
        "definition" : "Datum a čas hospitalizace. Doplní NIS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.lekarId",
        "path" : "LogInPatientEncounterCz.prijem.lekarId",
        "short" : "A.2.3.3.3 - Přijímající lékař - Id",
        "definition" : "Identifikátor přijímajícího lékaře dle NRZP. Doplní NIS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.lekarJmeno",
        "path" : "LogInPatientEncounterCz.prijem.lekarJmeno",
        "short" : "A.2.3.3.4 - Přijímající lékař - jméno",
        "definition" : "Jméno a příjmení přijímajícího lékaře. Doplní NIS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.zdroj",
        "path" : "LogInPatientEncounterCz.prijem.zdroj",
        "short" : "A.2.3.3.5 - Zdroj přijetí",
        "definition" : "Zdroj/doporučení k přijetí specifikuje odkud pacient do zařízení přišel, resp. kdo jej k hospitalizaci doporučil. Zadáno při příjmu výběrem ze seznamu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.doporucilId",
        "path" : "LogInPatientEncounterCz.prijem.doporucilId",
        "short" : "A.2.3.3.6 - Doporučující lékař - Id",
        "definition" : "Identifikátor odesílajícího lékaře dle NRZP. Zadáno při příjmu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.doporucilJmeno",
        "path" : "LogInPatientEncounterCz.prijem.doporucilJmeno",
        "short" : "A.2.3.3.7 - Doporučující lékař - jméno",
        "definition" : "Jméno a příjmení odesílajícího lékaře. Doplní NIS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.prijem.doporucilOrganizaceId",
        "path" : "LogInPatientEncounterCz.prijem.doporucilOrganizaceId",
        "short" : "A.2.3.3.8 - Doporučující zařízení - Id",
        "definition" : "Id, název poskytovatele a kontaktní informace. Doplní NIS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.duvodPrijeti",
        "path" : "LogInPatientEncounterCz.duvodPrijeti",
        "short" : "A.2.3.4 - Důvod přijetí",
        "definition" : "Důvod přijetí",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.duvodPrijeti.kod",
        "path" : "LogInPatientEncounterCz.duvodPrijeti.kod",
        "short" : "A.2.3.4.1 - Důvod přijetí - kód",
        "definition" : "Důvod přijetí textem a/nebo kódem problému, nálezu či procedury. Zadá lékař při příjmu výběrem ze seznamu",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.duvodPrijeti.komentar",
        "path" : "LogInPatientEncounterCz.duvodPrijeti.komentar",
        "short" : "A.2.3.4.2 - Důvod přijetí - komentář",
        "definition" : "Komentář k důvodu přijetí. Zadá lékař při příjmu volným textem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.duvodPrijeti.legalStatus",
        "path" : "LogInPatientEncounterCz.duvodPrijeti.legalStatus",
        "short" : "A.2.3.4.3 - Právní okolnosti přijetí",
        "definition" : "Právní okolnosti přijetí kódem a případně také textem. Zadá lékař při příjmu výběrem ze seznamu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.propusteni",
        "path" : "LogInPatientEncounterCz.propusteni",
        "short" : "A.2.3.5 - Propuštění",
        "definition" : "Propuštění",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.propusteni.datum",
        "path" : "LogInPatientEncounterCz.propusteni.datum",
        "short" : "A.2.3.5.1 - Datum a čas propuštění",
        "definition" : "Datum a čas propuštění. Zadá lékař",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.propusteni.cilPropusteni",
        "path" : "LogInPatientEncounterCz.propusteni.cilPropusteni",
        "short" : "A.2.3.5.2 - Cíl propuštění",
        "definition" : "Klasifikace místa, kam byl pacient propuštěn/přeložen. Zadá lékař výběrem ze seznamu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.propusteni.propusteniKam",
        "path" : "LogInPatientEncounterCz.propusteni.propusteniKam",
        "short" : "A.2.3.5.3 - Propuštěn kam",
        "definition" : "Identifikace organizace a adresa místa, kam byl pacient propuštěn/přeložen. Zadá lékař",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.pobyt",
        "path" : "LogInPatientEncounterCz.pobyt",
        "short" : "A.2.3.6 - Pobyt na oddělení",
        "definition" : "Pobyt na oddělení",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.pobyt.obdobi",
        "path" : "LogInPatientEncounterCz.pobyt.obdobi",
        "short" : "A.2.3.6.1 - od do",
        "definition" : "Období pobytu na oddělení. Doplní NIS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.pobyt.id",
        "path" : "LogInPatientEncounterCz.pobyt.id",
        "short" : "A.2.3.6.2 - Identifikátor oddělení",
        "definition" : "Úplný kód pracoviště/oddělení dle NRPZS. Doplní NIS",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.pobyt.nazev",
        "path" : "LogInPatientEncounterCz.pobyt.nazev",
        "short" : "A.2.3.6.3 - Název oddělení",
        "definition" : "Název oddělení. Doplní NIS",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogInPatientEncounterCz.pobyt.kontakt",
        "path" : "LogInPatientEncounterCz.pobyt.kontakt",
        "short" : "A.2.3.6.4 - Kontakty",
        "definition" : "Adresa a telekomunikační kontakty. Doplní NIS",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
