# A.2.3 - Encounter (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.3 - Encounter (eHN)**

## Logical Model: A.2.3 - Encounter (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/InPatientEncounterCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnEncounterEhnCz |

 
Hospital Discharge Report - Encounter - A.2.3 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/InPatientEncounterCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-InPatientEncounterCz.csv), [Excel](StructureDefinition-InPatientEncounterCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "InPatientEncounterCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/InPatientEncounterCz",
  "version" : "0.1.0",
  "name" : "LogEnEncounterEhnCz",
  "title" : "A.2.3 - Encounter (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Encounter - A.2.3 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/InPatientEncounterCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "InPatientEncounterCz",
        "path" : "InPatientEncounterCz",
        "short" : "A.2.3 - Encounter (eHN)",
        "definition" : "Hospital Discharge Report - Encounter - A.2.3 eHN"
      },
      {
        "id" : "InPatientEncounterCz.type",
        "path" : "InPatientEncounterCz.type",
        "short" : "A.2.3.1 - Encounter type",
        "definition" : "The type of the encounter whether inpatient or short stay encounter.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.note",
        "path" : "InPatientEncounterCz.note",
        "short" : "A.2.3.2 - Encounter note",
        "definition" : "A narrative description of the encounter course.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission",
        "path" : "InPatientEncounterCz.admission",
        "short" : "A.2.3.3 - Admission",
        "definition" : "Admission",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.urgency",
        "path" : "InPatientEncounterCz.admission.urgency",
        "short" : "A.2.3.3.1 - Admission urgency",
        "definition" : "Admission type, either emergency or planned",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.date",
        "path" : "InPatientEncounterCz.admission.date",
        "short" : "A.2.3.3.2 - Admission date",
        "definition" : "Admission date and time.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.admitter",
        "path" : "InPatientEncounterCz.admission.admitter",
        "short" : "Admitting professional",
        "definition" : "Admitting Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.admitter.identifier",
        "path" : "InPatientEncounterCz.admission.admitter.identifier",
        "short" : "A.2.3.3.3 - Admitting professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.admitter.name",
        "path" : "InPatientEncounterCz.admission.admitter.name",
        "short" : "A.2.3.3.4 - Admitting professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.admitter.organizationID",
        "path" : "InPatientEncounterCz.admission.admitter.organizationID",
        "short" : "A.2.3.3.5 - Admitting organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.admitter.organization",
        "path" : "InPatientEncounterCz.admission.admitter.organization",
        "short" : "A.2.3.3.6 - Admitting organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.source",
        "path" : "InPatientEncounterCz.admission.source",
        "short" : "A.2.3.3.7 - Admit Source",
        "definition" : "From where the patient was admitted (e.g. physician referral, transfer).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.referringHP",
        "path" : "InPatientEncounterCz.admission.referringHP",
        "short" : "Referring professional",
        "definition" : "Referring Healthcare Professional",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.referringHP.identifier",
        "path" : "InPatientEncounterCz.admission.referringHP.identifier",
        "short" : "A.2.3.3.8 - Referring professional ID",
        "definition" : "The health professional identification number. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.referringHP.name",
        "path" : "InPatientEncounterCz.admission.referringHP.name",
        "short" : "A.2.3.3.9 - Referring professional name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.referringHP.organizationID",
        "path" : "InPatientEncounterCz.admission.referringHP.organizationID",
        "short" : "A.2.3.3.10 - Referring organisation ID",
        "definition" : "The healthcare provider organisation identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admission.referringHP.organization",
        "path" : "InPatientEncounterCz.admission.referringHP.organization",
        "short" : "A.2.3.3.11 - Referring organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admissionReason",
        "path" : "InPatientEncounterCz.admissionReason",
        "short" : "A.2.3.4 - Admission reason",
        "definition" : "Admission reason",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admissionReason.code",
        "path" : "InPatientEncounterCz.admissionReason.code",
        "short" : "A.2.3.4.1 - Admission reason",
        "definition" : "Reason or reasons for admission, e.g. Problem, procedure or finding.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admissionReason.comment",
        "path" : "InPatientEncounterCz.admissionReason.comment",
        "short" : "A.2.3.4.2 - Admission reason comment",
        "definition" : "Explanation of the reason for the encounter.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.admissionReason.legalStatus",
        "path" : "InPatientEncounterCz.admissionReason.legalStatus",
        "short" : "A.2.3.4.3 - Admission legal status",
        "definition" : "Legal status/situation at admission. The legal status indicates the basis on which the patient is staying in a healthcare organisation. This can be either voluntary or involuntary, however the legal status is always determined by a court. A patient can also receive healthcare based on a forensic status. (voluntary, involuntary, admission by legal authority).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.discharge",
        "path" : "InPatientEncounterCz.discharge",
        "short" : "A.2.3.5 - Discharge",
        "definition" : "Discharge",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.discharge.date",
        "path" : "InPatientEncounterCz.discharge.date",
        "short" : "A.2.3.5.1 - Discharge date",
        "definition" : "Discharge date and time",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.discharge.destinationType",
        "path" : "InPatientEncounterCz.discharge.destinationType",
        "short" : "A.2.3.5.2 - Discharge destination type",
        "definition" : "Type of location to which the patient will go after the encounter. E.g. home, hospital, nursing home, left against medical advice etc.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.discharge.destinationLocation",
        "path" : "InPatientEncounterCz.discharge.destinationLocation",
        "short" : "A.2.3.5.3 - Destination location",
        "definition" : "The location/organisation to which the patient will go after the encounter. Name, address and telecommunication contact.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location",
        "path" : "InPatientEncounterCz.location",
        "short" : "A.2.3.6 - Location - All locations/departments where the patient stayed (was boarded) within the hospital.",
        "definition" : "Location - All locations/departments where the patient stayed (was boarded) within the hospital.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location.period",
        "path" : "InPatientEncounterCz.location.period",
        "short" : "A.2.3.6.1 - Period",
        "definition" : "Time period during which the patient was present at the location",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location.organization",
        "path" : "InPatientEncounterCz.location.organization",
        "short" : "Organization",
        "definition" : "Organization or organization part (hospital department) where the patient was present.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location.organization.identifier",
        "path" : "InPatientEncounterCz.location.organization.identifier",
        "short" : "A.2.3.6.2 - Organisation Part ID",
        "definition" : "The organisation’s part identifier.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location.organization.name",
        "path" : "InPatientEncounterCz.location.organization.name",
        "short" : "A.2.3.6.3 - Organisation Part Name",
        "definition" : "Full name of the organisation part, e.g. Name of the department",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "InPatientEncounterCz.location.organization.details",
        "path" : "InPatientEncounterCz.location.organization.details",
        "short" : "A.2.3.6.4 - Organisation Part Details",
        "definition" : "Address, contact names and contact details, specialty of the organisation part.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
