# A.2.6 - Hospital stay (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.6 - Hospital stay (eHN)**

## Logical Model: A.2.6 - Hospital stay (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/HospitalStayCz | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnHospitalStayEhnCz |

 
Hospital Discharge Report - Hospital stay - A.2.6 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/HospitalStayCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HospitalStayCz.csv), [Excel](StructureDefinition-HospitalStayCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HospitalStayCz",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalStayCz",
  "version" : "0.1.0",
  "name" : "LogEnHospitalStayEhnCz",
  "title" : "A.2.6 - Hospital stay (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Hospital stay - A.2.6 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/HospitalStayCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HospitalStayCz",
        "path" : "HospitalStayCz",
        "short" : "A.2.6 - Hospital stay (eHN)",
        "definition" : "Hospital Discharge Report - Hospital stay - A.2.6 eHN"
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary",
        "path" : "HospitalStayCz.diagnosticSummary",
        "short" : "A.2.7.1 - Diagnostic summary",
        "definition" : "All problems/diagnoses that affect care during the inpatient case or are important to be recorded to ensure continuity of care. The diagnostic summary differentiates, in accordance with the international recommendation, between problems treated during hospital stay and other (untreated) problems. Treated problems are problems that were the subject of diagnostics, therapy, nursing, or (continuous) monitoring during the hospitalisation. Furthermore problems could be divided into three categories: problems present on admission (POA), conditions acquired during hospital stay (HAC) and problems that cannot be classified as being of any of the two (N/A). The diagnostic summary contains all conditions as they were recognised at the end of hospitalisation, after all examinations. This section contains concise, well specified, codeable, summary of problems. Problems are ordered by importance (main problems first) during hospital stay. Description of the problem might be completed with additional details in the medical history section and/or in the Synthesis section.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.problemDescription",
        "path" : "HospitalStayCz.diagnosticSummary.problemDescription",
        "short" : "A.2.7.1.1 - Problem description",
        "definition" : "Problem specification in narrative form",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.problemDetails",
        "path" : "HospitalStayCz.diagnosticSummary.problemDetails",
        "short" : "A.2.7.1.2 - Problem details",
        "definition" : "Problem details include code that identifies problem, specification of the body structure, laterality, and other aspects of the problem.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.onsetDate",
        "path" : "HospitalStayCz.diagnosticSummary.onsetDate",
        "short" : "A.2.7.1.3 - Onset date",
        "definition" : "Onset date of a problem/condition",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.endDate",
        "path" : "HospitalStayCz.diagnosticSummary.endDate",
        "short" : "A.2.7.1.4 - End date",
        "definition" : "The date or estimated date that the condition resolved or went into remission.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.category",
        "path" : "HospitalStayCz.diagnosticSummary.category",
        "short" : "A.2.7.1.5 - Category",
        "definition" : "Category of the problem allows flagging for conditions acquired during hospital stay.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.treatmentClass",
        "path" : "HospitalStayCz.diagnosticSummary.treatmentClass",
        "short" : "A.2.7.1.6 - Treatment class",
        "definition" : "Class of the problem (treated, other) in relation to the hospital encounter. Treated problems were treated or affected provisioning of care (diagnostics, therapy, nursing, monitoring) during the hospital encounter. At least one problem should be marked as Treated. Other problems are recorded only if they are important for continuity of care (after discharge).",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.clinicalStatus",
        "path" : "HospitalStayCz.diagnosticSummary.clinicalStatus",
        "short" : "A.2.7.1.7 - Clinical status",
        "definition" : "Status of the condition/problem (active, resolved, inactive, ...)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.resolution",
        "path" : "HospitalStayCz.diagnosticSummary.resolution",
        "short" : "A.2.7.1.8 - Resolution circumstances",
        "definition" : "Describes the reason for which the status of the problem changed from current to inactive (e.g. surgical procedure, medical treatment, etc.). This field includes 'free text' if the resolution circumstances are not already included in other fields such as surgical procedure, medical device, etc., e.g. hepatic cystectomy (this will be the resolution circumstances for the problem 'hepatic cyst' and will be included in surgical procedures).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.severity",
        "path" : "HospitalStayCz.diagnosticSummary.severity",
        "short" : "A.2.7.1.9 - Severity",
        "definition" : "A subjective assessment of the severity of the condition as evaluated by the clinician.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.diagnosticSummary.stage",
        "path" : "HospitalStayCz.diagnosticSummary.stage",
        "short" : "A.2.7.1.10 - Stage",
        "definition" : "Stage/grade usually assessed formally using a specific staging/grading system. Multiple assessment systems could be used.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures",
        "path" : "HospitalStayCz.significantProcedures",
        "short" : "A.2.7.2 - Significant procedures",
        "definition" : "Significant surgical and non-surgical procedures performed during hospitalisation which are significant for continuity of care, e.g. surgeries and other 'instrumental' interventions (endoscopic, intravascular), chemotherapy, radiotherapy, purification methods (dialysis, hemoperfusion), circulation support methods (counterpulsation, etc.), administration of blood derivatives or others.\nThis section does not include purely diagnostic procedures (MRI, CT, etc.). If no significant performance has been performed, this fact must be explicitly stated using the IPS Absent and Unknown Data.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.procedureCode",
        "path" : "HospitalStayCz.significantProcedures.procedureCode",
        "short" : "A.2.7.2.1 - Procedure code",
        "definition" : "Procedure code",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.description",
        "path" : "HospitalStayCz.significantProcedures.description",
        "short" : "A.2.7.2.2 - Procedure description",
        "definition" : "Narrative description of the procedure",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.bodySite",
        "path" : "HospitalStayCz.significantProcedures.bodySite",
        "short" : "A.2.7.2.3 - Body site",
        "definition" : "Procedure target body site and laterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.date",
        "path" : "HospitalStayCz.significantProcedures.date",
        "short" : "A.2.7.2.4 - Procedure date",
        "definition" : "Date and time when procedure was performed",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.reason",
        "path" : "HospitalStayCz.significantProcedures.reason",
        "short" : "A.2.7.2.5 - Procedure reason",
        "definition" : "The coded reason why the procedure was performed. This may be a coded entity or may simply be present as text.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.outcome",
        "path" : "HospitalStayCz.significantProcedures.outcome",
        "short" : "A.2.7.2.6 - Outcome",
        "definition" : "The outcome of the procedure - did it resolve the reasons for the procedure being performed?",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.complication",
        "path" : "HospitalStayCz.significantProcedures.complication",
        "short" : "A.2.7.2.7 - Complication",
        "definition" : "Any complications that occurred during the procedure, or in the immediate post-performance period. These are generally tracked separately from the procedure description, which will typically describe the procedure itself rather than any 'post procedure' issues.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantProcedures.focalDevice",
        "path" : "HospitalStayCz.significantProcedures.focalDevice",
        "short" : "A.2.7.2.8 - Focal device",
        "definition" : "A reference to the device or devices that is/are implanted, removed, or otherwise manipulated (calibration, battery replacement, fitting a prosthesis, attaching a wound-vac, etc.) as a focal portion of the Procedure.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices",
        "path" : "HospitalStayCz.medicalDevices",
        "short" : "A.2.7.3 - Medical devices and implants",
        "definition" : "Implants and used medical devices that affected or may affect the provision of health services (diagnosis and treatment). Also medical devices explanted, or its use was stopped during hospitalisation. If the section is blank, the reason must be explicitly stated using the IPS Absent and Unknown Data coding system",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices.description",
        "path" : "HospitalStayCz.medicalDevices.description",
        "short" : "A.2.7.3.1 - Device and implant description",
        "definition" : "Describes the patient's implanted and external medical devices and equipment upon which their health status depends. Includes devices such as cardiac pacemakers, implantable fibrillator, prosthesis, ferromagnetic bone implants, etc. of which the HP needs to be aware.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices.identifier",
        "path" : "HospitalStayCz.medicalDevices.identifier",
        "short" : "A.2.7.3.2 - Device ID",
        "definition" : "Normalised identifier of the device instance such as UDI according to REGULATION (EU) 2017/745",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices.implantDate",
        "path" : "HospitalStayCz.medicalDevices.implantDate",
        "short" : "A.2.7.3.3 - Implant date",
        "definition" : "The date and time the device was implanted or when its use began.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices.endDate",
        "path" : "HospitalStayCz.medicalDevices.endDate",
        "short" : "A.2.7.3.4 - End date",
        "definition" : "Date and time when the device was explanted from the patient or the external device was no longer in use; likewise when the device is planned to be explanted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.medicalDevices.reason",
        "path" : "HospitalStayCz.medicalDevices.reason",
        "short" : "A.2.7.3.5 - Reason",
        "definition" : "The medical reason for use of the medical device.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy",
        "path" : "HospitalStayCz.pharmacotherapy",
        "short" : "A.2.7.5 - Pharmacotherapy",
        "definition" : "Selected drug treatment during hospitalisation. Medicinal products that were administered during hospitalisation and whose administration has already been discontinued before discharge. Only products which are important for continuity of care (antibiotics other than completely routine, corticosteroids in high doses, etc.) will be listed. Products which administration will continue after discharge will be also recorder in the Medication summary section.Medicinal products, the administration of which was started during hospitalisation, but is also recommended after discharge, will be listed in the summary table in the recommendation section.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.reason",
        "path" : "HospitalStayCz.pharmacotherapy.reason",
        "short" : "A.2.7.5.1 - Medication reason",
        "definition" : "The reason why the medication is or was prescribed or used. It provides a link to the Past or current health conditions or problems that the patient has had or has.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.productCode",
        "path" : "HospitalStayCz.pharmacotherapy.productCode",
        "short" : "A.2.7.5.2 - Code",
        "definition" : "Product code",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.intendedUse",
        "path" : "HospitalStayCz.pharmacotherapy.intendedUse",
        "short" : "A.2.7.5.3 - Intended use",
        "definition" : "Indication intended use as: prevention or treatment Example: prophylaxis, treatment, diagnostic, anaesthesia.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.productName",
        "path" : "HospitalStayCz.pharmacotherapy.productName",
        "short" : "A.2.7.5.4 - Brand name",
        "definition" : "Brand name if biological medicinal product or when justified by the health professional (ref. Commission Directive 2012/52/EU)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.activeIngredient",
        "path" : "HospitalStayCz.pharmacotherapy.activeIngredient",
        "short" : "A.2.7.5.5 - Active ingredient list",
        "definition" : "Substance that alone or in combination with one or more other ingredients produces the intended activity of a medicinal product. Example: \\'paracetamol\\'",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.strength",
        "path" : "HospitalStayCz.pharmacotherapy.strength",
        "short" : "A.2.7.5.6 - Strength",
        "definition" : "The content of the active ingredient expressed quantifiably per dosage unit, per unit of volume or per unit of weight, according to the pharmaceutical dose form. Example: 500 mg per tablet",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.doseForm",
        "path" : "HospitalStayCz.pharmacotherapy.doseForm",
        "short" : "A.2.7.5.7 - Pharmaceutical dose form",
        "definition" : "The form in which a pharmaceutical product is presented in the medicinal product package (e.g. tablet, syrup)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.dosageRegimen",
        "path" : "HospitalStayCz.pharmacotherapy.dosageRegimen",
        "short" : "A.2.7.5.8 - Dosage Regimen",
        "definition" : "Number of units per intake and frequency of intake over a specified duration of time. Example: 1 tablet every 24h, for 10 days",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.route",
        "path" : "HospitalStayCz.pharmacotherapy.route",
        "short" : "A.2.7.5.9 - Route of administration",
        "definition" : "Path by which the pharmaceutical product is taken into or makes contact with the body.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.pharmacotherapy.period",
        "path" : "HospitalStayCz.pharmacotherapy.period",
        "short" : "A.2.7.5.10 - Period of treatment",
        "definition" : "The time interval when the patient was, or was not, given the medication.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults",
        "path" : "HospitalStayCz.significantResults",
        "short" : "A.2.7.6 - Significant Observation Results",
        "definition" : "Results of significant functional, diagnostic, and imaging examinations to ensure continuity of care, performed during hospitalisation. Results of examinations ordered but not yet delivered should be presented separately from results already delivered.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.date",
        "path" : "HospitalStayCz.significantResults.date",
        "short" : "A.2.7.6.1 - Date",
        "definition" : "Date and time of the observation",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.status",
        "path" : "HospitalStayCz.significantResults.status",
        "short" : "A.2.7.6.2 - Observation status",
        "definition" : "Status of the observation (e.g. registered, preliminary, final)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.description",
        "path" : "HospitalStayCz.significantResults.description",
        "short" : "A.2.7.6.3 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.details",
        "path" : "HospitalStayCz.significantResults.details",
        "short" : "A.2.7.6.4 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.result",
        "path" : "HospitalStayCz.significantResults.result",
        "short" : "A.2.7.6.5 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.significantResults.reporter",
        "path" : "HospitalStayCz.significantResults.reporter",
        "short" : "A.2.7.6.7 - Reporter",
        "definition" : "With certain observation results, e.g. there may also be an interpreter or a person responsible for validation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.synthesis",
        "path" : "HospitalStayCz.synthesis",
        "short" : "A.2.7.7 - Synthesis",
        "definition" : "This section provides clinical synthesis (e.g. description of reasons and course of hospital stay) clustered by managed conditions, Clinical synthesis may include clinical reasoning (differential diagnostics, explanation of clinical context) in clinically complex conditions.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.synthesis.description",
        "path" : "HospitalStayCz.synthesis.description",
        "short" : "A.2.7.7.1 - Problem synthesis",
        "definition" : "Summary description of the reason and course of hospitalisation for a specific problem.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HospitalStayCz.synthesis.reasoning",
        "path" : "HospitalStayCz.synthesis.reasoning",
        "short" : "A.2.7.7.2 - Clinical reasoning",
        "definition" : "The clinical summary can be concluded with a clinical consideration (diff. diagnosis, explanation of context, etc.) for clinically complex conditions.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      }
    ]
  }
}

```
