# A.2.4 - Admission evaluation (eHN) - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2.4 - Admission evaluation (eHN)**

## Logical Model: A.2.4 - Admission evaluation (eHN) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/hdr/StructureDefinition/AdmissionEvaluationEhnEn | *Version*:0.1.0 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnAdmissionEvaluationEhnEn |

 
Hospital Discharge Report - Admission evaluation - A.2.4 eHN 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.hdr|current/StructureDefinition/AdmissionEvaluationEhnEn)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AdmissionEvaluationEhnEn.csv), [Excel](StructureDefinition-AdmissionEvaluationEhnEn.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AdmissionEvaluationEhnEn",
  "url" : "https://hl7.cz/fhir/hdr/StructureDefinition/AdmissionEvaluationEhnEn",
  "version" : "0.1.0",
  "name" : "LogEnAdmissionEvaluationEhnEn",
  "title" : "A.2.4 - Admission evaluation (eHN)",
  "status" : "draft",
  "date" : "2025-12-22T16:16:03+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/hdr/StructureDefinition/AdmissionEvaluationEhnEn",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AdmissionEvaluationEhnEn",
        "path" : "AdmissionEvaluationEhnEn",
        "short" : "A.2.4 - Admission evaluation (eHN)",
        "definition" : "Hospital Discharge Report - Admission evaluation - A.2.4 eHN"
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings",
        "short" : "A.2.4.1 - Objective findings",
        "definition" : "Objective findings",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.date",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.date",
        "short" : "A.2.4.1.1 - Date and time",
        "definition" : "Date and time of the examination",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations",
        "short" : "A.2.4.1.3 - Anthropometric observations",
        "definition" : "Observation of Body weight and height of the patient, BMI, circumference of head, waist, hip, limbs and skin fold thickness.\nResult of the observation includes text, numeric and coded results of the measurement including measurement units. Multiple observations could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations.details",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations.details",
        "short" : "A.2.4.1.3.1 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation..",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations.result",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.anthropometricObservations.result",
        "short" : "A.2.4.1.3.2 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns",
        "short" : "A.2.4.1.4 - Vital signs",
        "definition" : "Vital signs observation:",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.description",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.description",
        "short" : "A.2.4.1.4.1 - Result description",
        "definition" : "Narrative representation of the observation result and findings.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.details",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.details",
        "short" : "A.2.4.1.4.2 - Observation details",
        "definition" : "Observation details include code that identifies observation, specification of the observed body structure or specimen, date and time of the specimen collection, observation method or protocol used and other aspects of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.result",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.vitalSigns.result",
        "short" : "A.2.4.1.4.3 - Observation result",
        "definition" : "Result of the observation including numeric and coded results of the measurement, details about how the tests were done to get the result values, information about reference ranges and result interpretation. Content of the observation result will vary according to the type of the observation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.physicalExamination",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.physicalExamination",
        "short" : "A.2.4.1.5 - Physical examination",
        "definition" : "Physical examination is the process of evaluating objective anatomical findings. It is typically the first diagnostic measure performed after taking the patient's history, which allows an initial assessment of symptoms and is useful for determining the differential diagnoses and further steps. Physical examination can be performed through observation, palpation, percussion, and auscultation.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.objectiveFindings.physicalExamination.note",
        "path" : "AdmissionEvaluationEhnEn.objectiveFindings.physicalExamination.note",
        "short" : "A.2.4.1.5.1 - Observation Note",
        "definition" : "A narrative description of the observation. It should be structured by the organ system (e.g. head, neck, body, arms, ...)",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus",
        "short" : "A.2.4.2 - Functional status",
        "definition" : "Functional status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus.description",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus.description",
        "short" : "A.2.4.2.1 - Description",
        "definition" : "Need for the patient to be continuously assessed by third parties; functional status may influence decisions about how to plan and administer treatments",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus.onsetDate",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus.onsetDate",
        "short" : "A.2.4.2.2 - Onset Date",
        "definition" : "Onset date of a condition",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentType",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentType",
        "short" : "A.2.4.2.3 - Functional assessment description",
        "definition" : "Description of the functional assessment",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentDate",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentDate",
        "short" : "A.2.4.2.4 - Functional assessment date",
        "definition" : "Date of the functional assessment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentResult",
        "path" : "AdmissionEvaluationEhnEn.functionalStatus.assessmentResult",
        "short" : "A.2.4.2.5 - Functional assessment result",
        "definition" : "Functional assessment result value",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
