# Signature of image order - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Signature of image order**

## Example Provenance: Signature of image order

Profile: [Provenance (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-provenance.html)

Provenance for Reference(DischargeBundle-Novak-Petr) (Identifier: `https://ncez.mzcr.cz/fhir/sid/ico`/27520536)

Summary

| | |
| :--- | :--- |
| Recorded | 2023-04-05 17:23:07+0000 |

**Agents**

* **Role**: 
  * **who**: [MUDr. Hana Doktorová](Practitioner-Practitioner-2.md)



## Resource Content

```json
{
  "resourceType" : "Provenance",
  "id" : "cdae7735-f7ee-4bc7-9cf3-3dc806a4eabb",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-provenance"]
  },
  "target" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
        "value" : "27520536"
      },
      "display" : "Reference(DischargeBundle-Novak-Petr)"
    }
  ],
  "recorded" : "2023-04-05T17:23:07Z",
  "agent" : [
    {
      "role" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
              "code" : "AUT"
            }
          ]
        }
      ],
      "who" : {
        "reference" : "Practitioner/Practitioner-2",
        "display" : "MUDr. Hana Doktorová"
      }
    }
  ],
  "signature" : [
    {
      "type" : [
        {
          "system" : "urn:iso-astm:E1762-95:2013",
          "code" : "1.2.840.10065.1.12.1.1",
          "display" : "Author's Signature"
        }
      ],
      "when" : "2023-04-05T17:23:07Z",
      "who" : {
        "reference" : "Practitioner/Practitioner-2",
        "identifier" : {
          "system" : "http://example.org/exampleSystem",
          "value" : "MUDr. Hana Doktorová"
        },
        "display" : "MUDr. Hana Doktorová"
      },
      "targetFormat" : "application/fhir+xml",
      "sigFormat" : "application/signature+xml",
      "data" : "dGhpcyBibG9iIGlzIHNuaXBwZWQ="
    }
  ]
}

```
