# Mracena2 - HL7 Czech Hospital Discharge Report Implementation Guide v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Mracena2**

## Example Patient: Mracena2

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Mračena Mrakomorová Female, DoB: 1971-11-26 ( Passport number (use: official, ))

-------

| | |
| :--- | :--- |
| Other Ids: | * `https://ncez.mzcr.cz/fhir/sid/rcis`/7161264528 (use: official, )
* `https://ncez.mzcr.cz/fhir/sid/rid`/4567891235
* Passport number/23476533 (use: official, )
 |
| Contact Detail | * [+420603853227](tel:+420603853227)
* Malé náměstí 13a, 150 00, Praha 5(home)
 |
| Languages: | * Czech (preferred)
* English
* German
 |
| matka: | * Biologická Matka Mrakomorová 
* [+420604123456](tel:+420604123456)
 |
| přítel/přítelkyně: | * Alena Dlouhá 
* Horná ulica 18, 123 45, Trenčín, Slovensko(home)
* [+420601111111](tel:+420601111111)
 |
| Links: | * General Practitioner: MUDr. Josef Švejk (Identifier: `https://ncez.mzcr.cz/fhir/sid/nrzp`/123456789)
 |
| Patient Nationality: | * code: Czechia
 |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "Mracena2",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "extension" : [
    {
      "extension" : [
        {
          "url" : "code",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "urn:iso:std:iso:3166",
                "code" : "CZ"
              }
            ]
          }
        }
      ],
      "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
    }
  ],
  "identifier" : [
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/rcis",
      "value" : "7161264528"
    },
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "4567891235"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-CZE",
      "value" : "23476533"
    },
    {
      "use" : "official",
      "type" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
            "code" : "PPN"
          }
        ]
      },
      "system" : "http://hl7.org/fhir/sid/passport-SVK",
      "value" : "88476522"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Mrakomorová",
      "given" : ["Mračena"]
    }
  ],
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420603853227",
      "use" : "home"
    }
  ],
  "gender" : "female",
  "birthDate" : "1971-11-26",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Malé náměstí 13a, 150 00, Praha 5",
      "line" : ["Malé náměstí 13a"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Malé náměstí"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "13a"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "15000",
      "country" : "CZ"
    }
  ],
  "contact" : [
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "MTH",
              "display" : "matka"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "N",
              "display" : "Příbuzný"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Mrakomorová",
        "given" : ["Biologická", "Matka"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420604123456",
          "use" : "mobile"
        }
      ]
    },
    {
      "relationship" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
              "code" : "FRND",
              "display" : "přítel/přítelkyně"
            },
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v2-0131",
              "code" : "C",
              "display" : "Emergentní kontakt"
            }
          ]
        }
      ],
      "name" : {
        "use" : "usual",
        "family" : "Dlouhá",
        "given" : ["Alena"]
      },
      "telecom" : [
        {
          "system" : "phone",
          "value" : "+420601111111",
          "use" : "home"
        }
      ],
      "address" : {
        "use" : "home",
        "type" : "physical",
        "text" : "Horná ulica 18, 123 45, Trenčín, Slovensko",
        "line" : ["Horná ulica 18"],
        "_line" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
                "valueString" : "Horná ulica"
              },
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
                "valueString" : "18"
              }
            ]
          }
        ],
        "city" : "Trenčín",
        "postalCode" : "12345",
        "country" : "SK"
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "en"
          }
        ]
      }
    },
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "de"
          }
        ]
      }
    }
  ],
  "generalPractitioner" : [
    {
      "identifier" : {
        "system" : "https://ncez.mzcr.cz/fhir/sid/nrzp",
        "value" : "123456789"
      },
      "display" : "MUDr. Josef Švejk"
    }
  ]
}

```
